/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.registry;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xpect.registry.IEmfFileExtensionInfo;
import org.eclipse.xpect.registry.IExtensionInfo;
import org.eclipse.xpect.registry.LazyClass;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class FileExtensionInfoRegistry
implements IEmfFileExtensionInfo.Registry {
    private static final String DEFAULT_RESOURCE_FACTORY = IResourceFactory.class.getName();
    private static final String DEFAULT_RESOURCE_SERVICE_PROVIDER = IResourceServiceProvider.class.getName();
    private static final String DEFAULT_RESOURCE_UI_SERVICE_PROVIDER = "org.eclipse.xtext.ui.resource.IResourceUIServiceProvider";
    private static final String DEFAULT_SHARED_STATE_MODULE = "org.eclipse.xtext.ui.shared.SharedStateModule";
    private final Map<String, IEmfFileExtensionInfo> fileExtension2Info;
    private final List<IEmfFileExtensionInfo> infos;
    private final List<String> issues;

    public static void main(String[] args) {
        System.out.println(new FileExtensionInfoRegistry());
    }

    public FileExtensionInfoRegistry() {
        this(IExtensionInfo.Registry.INSTANCE);
    }

    public FileExtensionInfoRegistry(IExtensionInfo.Registry registry) {
        ArrayList issues = Lists.newArrayList();
        this.infos = ImmutableList.copyOf(this.collectFileExtensionInfos(registry, issues));
        this.fileExtension2Info = ImmutableMap.copyOf(this.collectFileExtensionInfosByExt(this.infos));
        this.issues = ImmutableList.copyOf((Collection)issues);
    }

    private List<IEmfFileExtensionInfo> collectFileExtensionInfos(IExtensionInfo.Registry registry, Collection<String> issues) {
        ArrayList infos = Lists.newArrayList();
        for (IExtensionInfo ext : registry.getExtensions("org.eclipse.xpect.fileExtensions")) {
            infos.add(this.parseXpectFileExtensionInfo(ext));
        }
        for (IExtensionInfo ext : registry.getExtensions("org.eclipse.emf.ecore.extension_parser")) {
            infos.add(this.parseEmfExtensionParser(ext));
        }
        for (IExtensionInfo ext : registry.getExtensions("org.eclipse.xtext.extension_resourceServiceProvider")) {
            infos.add(this.parseXtextResourceUIServiceProvider(ext));
        }
        for (IExtensionInfo ext : registry.getExtensions("org.eclipse.ui.editors")) {
            ExtensionPointData editorInfo = this.parseEditorExtension(ext);
            if (editorInfo.editor == null || editorInfo.editor.getFactory() == null) continue;
            infos.add(editorInfo);
        }
        LinkedHashMultimap ext2info = LinkedHashMultimap.create();
        for (ExtensionPointData info : infos) {
            for (String ext : info.fileExtensions) {
                if (ext == null || "___xbase".equals(ext) || "xt".equals(ext)) continue;
                ext2info.put((Object)ext, (Object)info);
            }
        }
        ArrayList allInfos = Lists.newArrayList();
        LinkedHashMultimap name2xtextInfo = LinkedHashMultimap.create();
        for (String ext : ext2info.keySet()) {
            FileExtensionData merged = this.mergeByFileExt(ext, ext2info.get((Object)ext), issues);
            if (merged.languageID == null) {
                allInfos.add(this.toEmfFileExtensionInfo(merged, issues));
                continue;
            }
            name2xtextInfo.put((Object)merged.languageID, (Object)merged);
        }
        for (String name : name2xtextInfo.keySet()) {
            allInfos.add(this.mergeByLang(name, name2xtextInfo.get((Object)name), issues));
        }
        return allInfos;
    }

    private Map<String, IEmfFileExtensionInfo> collectFileExtensionInfosByExt(List<IEmfFileExtensionInfo> allInfos) {
        HashMap result = Maps.newHashMap();
        for (IEmfFileExtensionInfo info : allInfos) {
            for (String ext : info.getFileExtensions()) {
                result.put(ext, info);
            }
        }
        return result;
    }

    @Override
    public IEmfFileExtensionInfo getEmfFileExtensionInfo(String fileExtension) {
        return this.fileExtension2Info.get(fileExtension);
    }

    @Override
    public Collection<IEmfFileExtensionInfo> getFileExtensionInfos() {
        return this.infos;
    }

    private <T> T merge(T o1, T o2, Collection<IExtensionInfo> traceIn, Set<IExtensionInfo> tracOut, String name, String context, Collection<String> issues) {
        if (o2 != null) {
            IExtensionInfo cand;
            Collection<Object> trace = o2 instanceof LazyClass ? ((cand = ((LazyClass)o2).getTrace()) == null ? Collections.emptySet() : Collections.singleton(cand)) : traceIn;
            if (o1 == null) {
                if (trace != null) {
                    tracOut.addAll(trace);
                }
                return o2;
            }
            if (name != null && !o1.equals(o2)) {
                String message = "Conflicting " + name + ": '" + o1 + "' and '" + o2 + "'";
                HashSet set = Sets.newHashSet(tracOut);
                set.addAll(trace);
                ArrayList tr = Lists.newArrayList();
                for (IExtensionInfo e : set) {
                    tr.add(e + " from " + e.getLocation());
                }
                issues.add("WARNING:" + message + " " + context + " Traces:\n\t" + Joiner.on((String)"\n\t").join((Iterable)tr));
            }
        }
        return o1;
    }

    private FileExtensionData mergeByFileExt(String fileExtension, Collection<ExtensionPointData> infos, Collection<String> issues) {
        FileExtensionData result = new FileExtensionData();
        result.fileExtension = fileExtension;
        result.traces = Sets.newHashSet();
        String context = "FileExtension: " + fileExtension;
        for (ExtensionPointData info : infos) {
            Set<IExtensionInfo> trace = Collections.singleton(info.trace);
            result.languageID = this.merge(result.languageID, info.languageID, trace, result.traces, "Xtext LanguageIDs", context, issues);
            result.resFact = this.merge(result.resFact, info.resFact, trace, result.traces, "EMF Resource Factories", context, issues);
            result.resSvP = this.merge(result.resSvP, info.resSvP, trace, result.traces, "Xtext Resource Service Provider", context, issues);
            result.resUISvP = this.merge(result.resUISvP, info.resUISvP, trace, result.traces, "Xtext Resource UI Service Provider", context, issues);
            result.runtimeModule = this.merge(result.runtimeModule, info.runtimeModule, trace, result.traces, "Xtext Runtime Modules", context, issues);
            result.uiModule = this.merge(result.uiModule, info.uiModule, trace, result.traces, "Xtext UI Modules", context, issues);
            result.sharedModule = this.merge(result.sharedModule, info.sharedModule, trace, result.traces, "Xtext Shared State Modules", context, issues);
            result.editor = this.merge(result.editor, info.editor, trace, result.traces, null, context, issues);
        }
        return result;
    }

    private XtextFileExtensionInfo mergeByLang(String langID, Collection<FileExtensionData> infos, Collection<String> issues) {
        HashSet traces = Sets.newHashSet();
        HashSet fileExtensions = Sets.newHashSet();
        LazyClass resFact = null;
        LazyClass rsp = null;
        LazyClass rUIsp = null;
        LazyClass runtimeModule = null;
        LazyClass uiModule = null;
        LazyClass sharedModule = null;
        LazyClass editor = null;
        String context = "XtextLanguageID: " + langID;
        for (FileExtensionData info : infos) {
            fileExtensions.add(info.fileExtension);
            resFact = this.merge(resFact, info.resFact, info.traces, traces, "EMF Resource Factories", context, issues);
            rsp = this.merge(rsp, info.resSvP, info.traces, traces, "Xtext Resource Service Provider", context, issues);
            rUIsp = this.merge(rUIsp, info.resUISvP, info.traces, traces, "Xtext Resource UI Service Provider", context, issues);
            runtimeModule = this.merge(runtimeModule, info.runtimeModule, info.traces, traces, "Xtext Runtime Modules", context, issues);
            uiModule = this.merge(uiModule, info.uiModule, info.traces, traces, "Xtext UI Modules", context, issues);
            sharedModule = this.merge(sharedModule, info.sharedModule, info.traces, traces, "Xtext Shared State Modules", context, issues);
            editor = this.merge(editor, info.editor, info.traces, traces, null, context, issues);
        }
        if (resFact == null && runtimeModule != null) {
            resFact = LazyClass.create(Resource.Factory.class, DEFAULT_RESOURCE_FACTORY, runtimeModule.getLoader());
        }
        if (rsp == null && runtimeModule != null) {
            rsp = LazyClass.create(IResourceServiceProvider.class, DEFAULT_RESOURCE_SERVICE_PROVIDER, runtimeModule.getLoader());
        }
        if (uiModule == null) {
            LazyClass[] lazyClassArray = new LazyClass[]{rUIsp, editor, resFact, rsp};
            int n = lazyClassArray.length;
            int n2 = 0;
            while (n2 < n) {
                LazyClass clazz = lazyClassArray[n2];
                if (clazz != null && clazz.getFactory() != null) {
                    uiModule = LazyClass.create(Module.class, String.valueOf(clazz.getFactory()) + "UiModule", clazz.getLoader());
                    break;
                }
                ++n2;
            }
        }
        if (rUIsp == null && uiModule != null) {
            rUIsp = LazyClass.create(IResourceServiceProvider.class, DEFAULT_RESOURCE_UI_SERVICE_PROVIDER, uiModule.getLoader());
        }
        if (sharedModule == null && uiModule != null) {
            sharedModule = LazyClass.create(Module.class, DEFAULT_SHARED_STATE_MODULE, uiModule.getLoader());
        }
        return new XtextFileExtensionInfo(fileExtensions, resFact, langID, rsp, rUIsp, runtimeModule, uiModule, sharedModule, traces);
    }

    private ExtensionPointData parseEditorExtension(IExtensionInfo info) {
        ExtensionPointData result = new ExtensionPointData(info, "extensions");
        result.languageID = info.getAttributeValue("id");
        result.runtimeModule = LazyClass.create(Module.class, String.valueOf(result.languageID) + "RuntimeModule", info);
        result.editor = LazyClass.create(Object.class, info, "class");
        return result;
    }

    private ExtensionPointData parseEmfExtensionParser(IExtensionInfo info) {
        ExtensionPointData result = new ExtensionPointData(info, "type");
        result.resFact = LazyClass.create(Resource.Factory.class, info, "class");
        return result;
    }

    private ExtensionPointData parseXpectFileExtensionInfo(IExtensionInfo info) {
        ExtensionPointData result = new ExtensionPointData(info, "fileExtension");
        result.resFact = LazyClass.create(Resource.Factory.class, info, "emfResourceFactory");
        result.languageID = info.getAttributeValue("xtextLanguageName");
        result.resSvP = LazyClass.create(IResourceServiceProvider.class, info, "xtextResourceServiceProvider");
        result.resUISvP = LazyClass.create(IResourceServiceProvider.class, info, "xtextResourceUIServiceProvider");
        result.runtimeModule = LazyClass.create(Module.class, info, "xtextRuntimeModule");
        result.uiModule = LazyClass.create(Module.class, info, "xtextUiModule");
        result.sharedModule = LazyClass.create(Module.class, info, "xtextSharedStateModule");
        return result;
    }

    private ExtensionPointData parseXtextResourceUIServiceProvider(IExtensionInfo info) {
        ExtensionPointData result = new ExtensionPointData(info, "uriExtension");
        result.resUISvP = LazyClass.create(IResourceServiceProvider.class, info, "class");
        return result;
    }

    private EmfFileExtensionInfo toEmfFileExtensionInfo(FileExtensionData info, Collection<String> issues) {
        this.warnIfSet(info, info.resSvP, "resourceServiceProvider", issues);
        this.warnIfSet(info, info.resUISvP, "resourceUIServiceProvider", issues);
        this.warnIfSet(info, info.runtimeModule, "runtimeModule", issues);
        return new EmfFileExtensionInfo(Collections.singleton(info.fileExtension), info.resFact, info.traces);
    }

    public String toString() {
        return Joiner.on((String)"\n").join(Iterables.concat(this.issues, this.infos));
    }

    private void warnIfSet(FileExtensionData info, Object value, String name, Collection<String> issues) {
        if (value != null) {
            issues.add("WARNING: Ignoring " + name + " '" + value + "' for fileExtension '" + info.fileExtension + "' from " + info.getLocations());
        }
    }

    private static abstract class Data {
        protected LazyClass<Object> editor = null;
        protected String languageID = null;
        protected LazyClass<Resource.Factory> resFact = null;
        protected LazyClass<IResourceServiceProvider> resSvP = null;
        protected LazyClass<IResourceServiceProvider> resUISvP = null;
        protected LazyClass<Module> runtimeModule = null;
        protected LazyClass<Module> sharedModule = null;
        protected LazyClass<Module> uiModule = null;

        private Data() {
        }

        protected abstract String getFileExtensionString();

        public String toString() {
            ToStringBuilder result = new ToStringBuilder((Object)this).verbatimValues().singleLine().add("fileExtension", (Object)this.getFileExtensionString());
            if (this.resFact != null && !DEFAULT_RESOURCE_FACTORY.equals(this.resFact.getName())) {
                result.add("resourceFactory", this.resFact);
            }
            if (this.languageID != null) {
                result.add("languageID", (Object)this.languageID);
            }
            if (this.runtimeModule != null) {
                result.add("runtimeModule", this.runtimeModule);
            }
            if (this.uiModule != null) {
                result.add("uiModule", this.uiModule);
            }
            if (this.sharedModule != null && !FileExtensionInfoRegistry.DEFAULT_SHARED_STATE_MODULE.equals(this.sharedModule.getName())) {
                result.add("sharedStateModule", this.sharedModule);
            }
            if (this.resSvP != null && !DEFAULT_RESOURCE_SERVICE_PROVIDER.equals(this.resSvP.getName())) {
                result.add("resourceServiceProvider", this.resSvP);
            }
            if (this.resUISvP != null && !FileExtensionInfoRegistry.DEFAULT_RESOURCE_UI_SERVICE_PROVIDER.equals(this.resUISvP.getName())) {
                result.add("resourceUIServiceProvider", this.resUISvP);
            }
            return result.toString();
        }
    }

    public static class EmfFileExtensionInfo
    implements IEmfFileExtensionInfo {
        private final Set<String> fileExtensions;
        private final LazyClass<Resource.Factory> resourceFactory;
        private final Set<IExtensionInfo> traces;

        public EmfFileExtensionInfo(Set<String> fileExtensions, LazyClass<Resource.Factory> resourceFactory, Set<IExtensionInfo> traces) {
            this.traces = ImmutableSet.copyOf(traces);
            this.fileExtensions = ImmutableSet.copyOf(fileExtensions);
            this.resourceFactory = resourceFactory;
        }

        @Override
        public Set<String> getFileExtensions() {
            return this.fileExtensions;
        }

        @Override
        public LazyClass<Resource.Factory> getResourceFactory() {
            return this.resourceFactory;
        }

        public Set<IExtensionInfo> getTraces() {
            return this.traces;
        }

        public String toString() {
            ArrayList extensions = Lists.newArrayList(this.fileExtensions);
            Collections.sort(extensions);
            ToStringBuilder result = new ToStringBuilder((Object)this).verbatimValues().singleLine().add("fileExtensions", (Object)extensions);
            if (this.resourceFactory != null && !DEFAULT_RESOURCE_FACTORY.equals(this.resourceFactory.getName())) {
                result.add("resourceFactory", this.resourceFactory);
            }
            return result.toString();
        }
    }

    private static class ExtensionPointData
    extends Data {
        private Set<String> fileExtensions;
        private IExtensionInfo trace;

        public ExtensionPointData(IExtensionInfo trace, String fileExtensionAttributeName) {
            this.trace = trace;
            this.fileExtensions = Sets.newHashSet();
            String exts = trace.getAttributeValue(fileExtensionAttributeName);
            if (exts != null) {
                String[] stringArray = exts.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String ext = stringArray[n2];
                    this.fileExtensions.add(ext.trim());
                    ++n2;
                }
            }
        }

        @Override
        protected String getFileExtensionString() {
            return Joiner.on((String)", ").join(this.fileExtensions);
        }
    }

    private static class FileExtensionData
    extends Data {
        protected String fileExtension;
        protected Set<IExtensionInfo> traces;

        private FileExtensionData() {
        }

        @Override
        protected String getFileExtensionString() {
            return this.fileExtension;
        }

        public List<String> getLocations() {
            ArrayList locations = Lists.newArrayList();
            for (IExtensionInfo trace : this.traces) {
                String location = trace.getLocation();
                if (Strings.isEmpty((String)location)) continue;
                locations.add(location);
            }
            return locations;
        }
    }

    public static class XtextFileExtensionInfo
    extends EmfFileExtensionInfo
    implements IEmfFileExtensionInfo.IXtextFileExtensionInfo {
        private final String languageID;
        private final LazyClass<IResourceServiceProvider> resourceServiceProvider;
        private final LazyClass<IResourceServiceProvider> resourceUIServiceProvider;
        private final LazyClass<Module> runtimeModule;
        private final LazyClass<Module> sharedModule;
        private final LazyClass<Module> uiModule;

        public XtextFileExtensionInfo(Set<String> fileExtensions, LazyClass<Resource.Factory> resourceFactory, String languageID, LazyClass<IResourceServiceProvider> resourceServiceProvider, LazyClass<IResourceServiceProvider> resourceUIServiceProvider, LazyClass<Module> runtimeModule, LazyClass<Module> uiModule, LazyClass<Module> sharedModule, Set<IExtensionInfo> traces) {
            super(fileExtensions, resourceFactory, traces);
            this.languageID = languageID;
            this.resourceServiceProvider = resourceServiceProvider;
            this.resourceUIServiceProvider = resourceUIServiceProvider;
            this.runtimeModule = runtimeModule;
            this.uiModule = uiModule;
            this.sharedModule = sharedModule;
        }

        @Override
        public String getLanguageID() {
            return this.languageID;
        }

        @Override
        public LazyClass<IResourceServiceProvider> getResourceServiceProvider() {
            return this.resourceServiceProvider;
        }

        @Override
        public LazyClass<IResourceServiceProvider> getResourceUIServiceProvider() {
            return this.resourceUIServiceProvider;
        }

        @Override
        public LazyClass<Module> getRuntimeModule() {
            return this.runtimeModule;
        }

        @Override
        public LazyClass<Module> getSharedModule() {
            return this.sharedModule;
        }

        @Override
        public LazyClass<Module> getUIModule() {
            return this.uiModule;
        }

        public boolean hasInjector() {
            return this.runtimeModule != null;
        }

        @Override
        public String toString() {
            ArrayList extensions = Lists.newArrayList(this.getFileExtensions());
            Collections.sort(extensions);
            ToStringBuilder result = new ToStringBuilder((Object)this).verbatimValues().singleLine().add("fileExtensions", (Object)extensions);
            if (this.getResourceFactory() != null && !DEFAULT_RESOURCE_FACTORY.equals(this.getResourceFactory().getName())) {
                result.add("resourceFactory", this.getResourceFactory());
            }
            if (this.languageID != null) {
                result.add("languageID", (Object)this.languageID);
            }
            if (this.runtimeModule != null) {
                result.add("runtimeModule", this.runtimeModule);
            }
            if (this.uiModule != null) {
                result.add("uiModule", this.uiModule);
            }
            if (this.resourceServiceProvider != null && !DEFAULT_RESOURCE_SERVICE_PROVIDER.equals(this.resourceServiceProvider.getName())) {
                result.add("resourceServiceProvider", this.resourceServiceProvider);
            }
            if (this.resourceUIServiceProvider != null && !FileExtensionInfoRegistry.DEFAULT_RESOURCE_UI_SERVICE_PROVIDER.equals(this.resourceUIServiceProvider.getName())) {
                result.add("resourceUIServiceProvider", this.resourceUIServiceProvider);
            }
            return result.toString();
        }
    }
}

