/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.utils;

import com.google.common.base.Function;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.scoping.imports.ImportedElementsScopingHelper;
import org.eclipse.n4js.scoping.utils.ScopesHelper;
import org.eclipse.n4js.scoping.utils.WrongStaticAccessDescription;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.TypeRefsPackage;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.TStructMember;
import org.eclipse.n4js.ts.types.TStructMethod;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.SingletonScope;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class LocallyKnownTypesScopingHelper {
    @Inject
    private IResourceScopeCache cache;
    @Inject
    private ImportedElementsScopingHelper importedElementsScopingHelper;
    @Inject
    private ScopesHelper scopesHelper;

    public IScope scopeWithTypeAndItsTypeVariables(IScope parent, Type type, boolean staticAccess) {
        IScope result = parent;
        if (type != null) {
            boolean _isGeneric;
            boolean _tripleNotEquals;
            String _name = type.getName();
            boolean bl = _tripleNotEquals = _name != null;
            if (_tripleNotEquals) {
                IEObjectDescription _create = EObjectDescription.create((String)type.getName(), (EObject)type);
                SingletonScope _singletonScope = new SingletonScope(_create, result);
                result = _singletonScope;
            }
            if (_isGeneric = type.isGeneric()) {
                if (type instanceof TClassifier && staticAccess) {
                    Function _function = it -> new WrongStaticAccessDescription((IEObjectDescription)it, staticAccess);
                    result = this.scopesHelper.scopeFor((Iterable<? extends EObject>)type.getTypeVars(), (Function<IEObjectDescription, ? extends IEObjectDescription>)_function, result);
                } else {
                    result = Scopes.scopeFor((Iterable)type.getTypeVars(), (IScope)result);
                }
            }
        }
        return result;
    }

    public IScope scopeWithTypeVarsOfTStructMethod(IScope parent, TStructMethod m) {
        boolean _isGeneric;
        TStructMember mDef = m.getDefinedMember();
        if (mDef instanceof TStructMethod && (_isGeneric = ((TStructMethod)mDef).isGeneric())) {
            return Scopes.scopeFor((Iterable)((TStructMethod)mDef).getTypeVars(), (IScope)parent);
        }
        return parent;
    }

    public IScope scopeWithTypeVarsOfFunctionTypeExpression(IScope parent, FunctionTypeExpression funTypeExpr) {
        if (funTypeExpr != null && funTypeExpr.isGeneric()) {
            return Scopes.scopeFor((Iterable)funTypeExpr.getTypeVars(), (IScope)parent);
        }
        return parent;
    }

    public IScope scopeWithLocallyKnownTypes(Script script, IScopeProvider delegate) {
        Pair _mappedTo = Pair.of((Object)script, (Object)"locallyKnownTypes");
        Provider _function = () -> {
            IScope parent = delegate.getScope((EObject)script, TypeRefsPackage.Literals.PARAMETERIZED_TYPE_REF__DECLARED_TYPE);
            IScope importScope = this.importedElementsScopingHelper.getImportedTypes(parent, script);
            IScope localTypes = this.scopeWithLocallyDeclaredTypes(script, importScope);
            return localTypes;
        };
        return (IScope)this.cache.get((Object)_mappedTo, script.eResource(), _function);
    }

    public IScope scopeWithLocallyDeclaredTypes(Script script, IScope parent) {
        TModule local = script.getModule();
        if (local == null || local.eIsProxy()) {
            return parent;
        }
        Functions.Function1 _function = topLevelType -> EObjectDescription.create((String)topLevelType.getName(), (EObject)topLevelType);
        return this.scopesHelper.mapBasedScopeFor((EObject)script, parent, ListExtensions.map((List)local.getTopLevelTypes(), (Functions.Function1)_function));
    }

    public IScope scopeWithLocallyKnownTypesForPolyfillSuperRef(Script script, IScopeProvider delegate, Type polyfillType) {
        IScope parent = delegate.getScope((EObject)script, TypeRefsPackage.Literals.PARAMETERIZED_TYPE_REF__DECLARED_TYPE);
        IScope importScope = this.importedElementsScopingHelper.getImportedTypes(parent, script);
        TModule local = script.getModule();
        Functions.Function1 _function = it -> it != polyfillType;
        Functions.Function1 _function_1 = it -> EObjectDescription.create((String)it.getName(), (EObject)it);
        IScope localTypesScope = this.scopesHelper.mapBasedScopeFor((EObject)script, importScope, IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)local.getTopLevelTypes(), (Functions.Function1)_function), (Functions.Function1)_function_1));
        boolean _isGeneric = polyfillType.isGeneric();
        if (_isGeneric) {
            return Scopes.scopeFor((Iterable)polyfillType.getTypeVars(), (IScope)localTypesScope);
        }
        return localTypesScope;
    }
}

