/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.external;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.n4js.external.ExternalLibraryWorkspace;
import org.eclipse.n4js.external.N4JSExternalProject;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;

public class ShadowingInfoHelper {
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private ExternalLibraryWorkspace externalLibraryWorkspace;

    public boolean isShadowingProject(IN4JSProject project) {
        return !this.findShadowedProjects(project).isEmpty();
    }

    public boolean isShadowedProject(IN4JSProject project) {
        return !this.findShadowingProjects(project).isEmpty();
    }

    public List<IN4JSProject> findShadowingProjects(IN4JSProject project) {
        IN4JSProject shadowingProject;
        N4JSProjectName projectName = project.getProjectName();
        LinkedList<IN4JSProject> shadowingProjects = new LinkedList<IN4JSProject>();
        if (!project.isExternal()) {
            return shadowingProjects;
        }
        List<N4JSExternalProject> projectsForName = this.externalLibraryWorkspace.getProjectsForName(projectName);
        if (projectsForName != null && !projectsForName.isEmpty()) {
            N4JSExternalProject sameNamePrj;
            SafeURI<?> prjLoc = project.getLocation();
            LinkedList<N4JSExternalProject> projectsForNameReversed = new LinkedList<N4JSExternalProject>(projectsForName);
            Collections.reverse(projectsForNameReversed);
            Iterator sameNamedPrjsIter = projectsForNameReversed.iterator();
            while (sameNamedPrjsIter.hasNext()) {
                sameNamePrj = (N4JSExternalProject)((Object)sameNamedPrjsIter.next());
                FileURI otherPrjLoc = sameNamePrj.getSafeLocation();
                if (prjLoc.equals(otherPrjLoc)) break;
            }
            while (sameNamedPrjsIter.hasNext()) {
                sameNamePrj = (N4JSExternalProject)((Object)sameNamedPrjsIter.next());
                shadowingProjects.add(sameNamePrj.getIProject());
            }
        }
        if ((shadowingProject = (IN4JSProject)this.n4jsCore.findProject(projectName).orNull()) != null && shadowingProject.exists() && !shadowingProject.isExternal()) {
            shadowingProjects.add(shadowingProject);
        }
        return shadowingProjects;
    }

    public List<N4JSExternalProject> findShadowedProjects(IN4JSProject project) {
        N4JSExternalProject sameNamePrj;
        N4JSProjectName projectName = project.getProjectName();
        List<N4JSExternalProject> projectsForName = this.externalLibraryWorkspace.getProjectsForName(projectName);
        if (projectsForName == null || projectsForName.isEmpty()) {
            return Collections.emptyList();
        }
        if (!project.isExternal()) {
            return projectsForName;
        }
        LinkedList<N4JSExternalProject> shadowedProjects = new LinkedList<N4JSExternalProject>();
        SafeURI<?> prjLoc = project.getLocation();
        projectsForName = new LinkedList<N4JSExternalProject>(projectsForName);
        Iterator<N4JSExternalProject> sameNamedPrjsIter = projectsForName.iterator();
        while (sameNamedPrjsIter.hasNext()) {
            sameNamePrj = sameNamedPrjsIter.next();
            SafeURI<?> otherPrjLoc = sameNamePrj.getIProject().getLocation();
            if (prjLoc.equals(otherPrjLoc)) break;
        }
        while (sameNamedPrjsIter.hasNext()) {
            sameNamePrj = sameNamedPrjsIter.next();
            shadowedProjects.add(sameNamePrj);
        }
        return shadowedProjects;
    }
}

