/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.scoping.builtin;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.util.Strings;

public interface N4Scheme {
    public static final String SCHEME = "n4scheme";

    public static boolean isN4Scheme(URI uri) {
        return SCHEME.equals(uri.scheme());
    }

    public static boolean isFromResourceWithN4Scheme(EObject to) {
        if (to.eIsProxy()) {
            return N4Scheme.isN4Scheme(EcoreUtil.getURI((EObject)to));
        }
        return N4Scheme.isResourceWithN4Scheme(to.eResource());
    }

    public static boolean isResourceWithN4Scheme(Resource res) {
        return N4Scheme.isN4Scheme(res.getURI());
    }

    public static URI toClasspathURI(URI uriWithN4Scheme) {
        String[] allSegments = new String[uriWithN4Scheme.segmentCount() + 1];
        allSegments[0] = "env";
        int i = 0;
        while (i < uriWithN4Scheme.segmentCount()) {
            allSegments[i + 1] = uriWithN4Scheme.segment(i);
            ++i;
        }
        URI classpathURI = URI.createHierarchicalURI((String)"classpath", (String)uriWithN4Scheme.authority(), (String)uriWithN4Scheme.device(), (String[])allSegments, (String)uriWithN4Scheme.query(), (String)uriWithN4Scheme.fragment());
        return classpathURI;
    }

    public static class N4URI {
        public static URI create(String path) {
            return N4URI.create(path, null);
        }

        private static URI create(String path, String fragment) {
            List segments = Strings.split((String)path, (char)'/');
            URI result = URI.createHierarchicalURI((String)N4Scheme.SCHEME, null, null, (String[])segments.toArray(new String[segments.size()]), null, (String)fragment);
            return result;
        }
    }
}

