/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.subsystems.files.core;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rse.internal.subsystems.files.core.SystemFileResources;
import org.eclipse.rse.services.clientserver.SystemEncodingUtil;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    private static Activator plugin;
    public static final String PLUGIN_ID = "org.eclipse.rse.subsystems.files.core";

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Job setupEncodingProvider = new Job(SystemFileResources.RESID_JOB_SETUP_ENCODING_PROVIDER){

            public IStatus run(IProgressMonitor monitor) {
                SystemEncodingUtil encodingUtil = SystemEncodingUtil.getInstance();
                encodingUtil.setDefaultEncodingProvider((SystemEncodingUtil.DefaultEncodingProvider)new RSEDefaultEncodingProvider());
                return Status.OK_STATUS;
            }
        };
        setupEncodingProvider.setSystem(true);
        setupEncodingProvider.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static Activator getDefault() {
        return plugin;
    }

    class RSEDefaultEncodingProvider
    extends SystemEncodingUtil.DefaultEncodingProvider {
        RSEDefaultEncodingProvider() {
        }

        public String getLocalDefaultEncoding() {
            return ResourcesPlugin.getEncoding();
        }

        public boolean isXML(String path) {
            boolean result = super.isXML(path);
            if (!result) {
                RemoteFileUtility.getSystemFileTransferModeRegistry().isXML(path);
            }
            return result;
        }
    }
}

