/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.projectDescription;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ProjectType implements Enumerator
{
    PLAINJS(0, "PLAINJS", "PLAINJS"),
    VALIDATION(1, "VALIDATION", "VALIDATION"),
    DEFINITION(2, "DEFINITION", "DEFINITION"),
    APPLICATION(3, "APPLICATION", "APPLICATION"),
    PROCESSOR(4, "PROCESSOR", "PROCESSOR"),
    LIBRARY(5, "LIBRARY", "LIBRARY"),
    API(6, "API", "API"),
    RUNTIME_ENVIRONMENT(7, "RUNTIME_ENVIRONMENT", "RUNTIME_ENVIRONMENT"),
    RUNTIME_LIBRARY(8, "RUNTIME_LIBRARY", "RUNTIME_LIBRARY"),
    TEST(9, "TEST", "TEST");

    public static final int PLAINJS_VALUE = 0;
    public static final int VALIDATION_VALUE = 1;
    public static final int DEFINITION_VALUE = 2;
    public static final int APPLICATION_VALUE = 3;
    public static final int PROCESSOR_VALUE = 4;
    public static final int LIBRARY_VALUE = 5;
    public static final int API_VALUE = 6;
    public static final int RUNTIME_ENVIRONMENT_VALUE = 7;
    public static final int RUNTIME_LIBRARY_VALUE = 8;
    public static final int TEST_VALUE = 9;
    private static final ProjectType[] VALUES_ARRAY;
    public static final List<ProjectType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ProjectType[]{PLAINJS, VALIDATION, DEFINITION, APPLICATION, PROCESSOR, LIBRARY, API, RUNTIME_ENVIRONMENT, RUNTIME_LIBRARY, TEST};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ProjectType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ProjectType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ProjectType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ProjectType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ProjectType get(int value) {
        switch (value) {
            case 0: {
                return PLAINJS;
            }
            case 1: {
                return VALIDATION;
            }
            case 2: {
                return DEFINITION;
            }
            case 3: {
                return APPLICATION;
            }
            case 4: {
                return PROCESSOR;
            }
            case 5: {
                return LIBRARY;
            }
            case 6: {
                return API;
            }
            case 7: {
                return RUNTIME_ENVIRONMENT;
            }
            case 8: {
                return RUNTIME_LIBRARY;
            }
            case 9: {
                return TEST;
            }
        }
        return null;
    }

    private ProjectType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

