/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ExpressionStatement;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.StringLiteral;
import org.eclipse.n4js.utils.ResourceType;
import org.eclipse.xtext.EcoreUtil2;

public enum JavaScriptVariant {
    unrestricted,
    strict,
    n4js,
    external,
    n4idl;

    private static final Logger LOGGER;
    public static final String STRICT_MODE_LITERAL_VALUE = "use strict";

    static {
        LOGGER = Logger.getLogger(JavaScriptVariant.class);
    }

    public static Set<JavaScriptVariant> nonDepricatedValues() {
        JavaScriptVariant[] enumConstants;
        HashSet<JavaScriptVariant> nonDepricated = new HashSet<JavaScriptVariant>();
        JavaScriptVariant[] javaScriptVariantArray = enumConstants = (JavaScriptVariant[])JavaScriptVariant.class.getEnumConstants();
        int n = enumConstants.length;
        int n2 = 0;
        while (n2 < n) {
            JavaScriptVariant enumConstant = javaScriptVariantArray[n2];
            try {
                Annotation[] annotations;
                Field field = JavaScriptVariant.class.getDeclaredField(enumConstant.name());
                Annotation[] annotationArray = annotations = field.getAnnotations();
                int n3 = annotations.length;
                int n4 = 0;
                while (n4 < n3) {
                    Annotation annotation = annotationArray[n4];
                    Class<? extends Annotation> annotationType = annotation.annotationType();
                    if (!Deprecated.class.equals(annotationType)) {
                        nonDepricated.add(enumConstant);
                    }
                    ++n4;
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"Error when collecting all non-@Deprecated JavaScriptVariants", (Throwable)e);
            }
            ++n2;
        }
        return nonDepricated;
    }

    public static JavaScriptVariant getVariant(EObject eobj) {
        ResourceType resourceType = ResourceType.getResourceType(eobj);
        if (ResourceType.N4JS.equals((Object)resourceType)) {
            return n4js;
        }
        if (JavaScriptVariant.isContainedInStrictFunctionOrScript(eobj)) {
            return strict;
        }
        if (ResourceType.N4JSD.equals((Object)resourceType)) {
            return external;
        }
        return unrestricted;
    }

    public boolean isActive(EObject eobj) {
        return JavaScriptVariant.getVariant(eobj) == this;
    }

    public static boolean isContainedInStrictFunctionOrScript(EObject eobj) {
        if (eobj == null) {
            return false;
        }
        FunctionDefinition functionDef = (FunctionDefinition)EcoreUtil2.getContainerOfType((EObject)eobj, FunctionDefinition.class);
        if (functionDef != null) {
            Block block = functionDef.getBody();
            if (block != null && JavaScriptVariant.startsWithStrictMode((EList<? extends EObject>)block.getStatements())) {
                return true;
            }
            return JavaScriptVariant.isContainedInStrictFunctionOrScript(functionDef.eContainer());
        }
        Script script = (Script)EcoreUtil2.getContainerOfType((EObject)eobj, Script.class);
        return script != null && JavaScriptVariant.startsWithStrictMode((EList<? extends EObject>)script.getScriptElements());
    }

    private static boolean startsWithStrictMode(EList<? extends EObject> eList) {
        Expression expr;
        if (eList == null || eList.isEmpty()) {
            return false;
        }
        EObject first = (EObject)eList.get(0);
        if (first instanceof ExpressionStatement && (expr = ((ExpressionStatement)first).getExpression()) instanceof StringLiteral) {
            boolean equalsStrictLiteral = STRICT_MODE_LITERAL_VALUE.equals(((StringLiteral)expr).getValue());
            return equalsStrictLiteral;
        }
        return false;
    }

    public boolean isECMAScript() {
        return this == strict || this == unrestricted;
    }
}

