/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.dataflow;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.n4js.flowgraphs.dataflow.AssumptionGroup;
import org.eclipse.n4js.flowgraphs.dataflow.DataFlowVisitor;
import org.eclipse.n4js.flowgraphs.dataflow.EffectInfo;
import org.eclipse.n4js.flowgraphs.dataflow.PartialResult;
import org.eclipse.n4js.flowgraphs.dataflow.guards.Guard;
import org.eclipse.n4js.flowgraphs.dataflow.guards.GuardType;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.Symbol;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.Expression;

public abstract class Assumption {
    private final AssumptionGroup assumptionGroup;
    public final ControlFlowElement creationSite;
    public final Symbol symbol;
    public final Set<Symbol> aliases = new HashSet<Symbol>();
    public final Multimap<GuardType, Guard> guardsThatNeverHold = HashMultimap.create();
    public final Multimap<GuardType, Guard> guardsThatAlwaysHold = HashMultimap.create();
    public final Set<PartialResult> failedBranches = new HashSet<PartialResult>();
    public final Set<PartialResult> passedBranches = new HashSet<PartialResult>();
    public PartialResult terminatingGuard;
    private boolean openBranch = true;
    private DataFlowVisitor dataFlowVisitor;
    private boolean mergedAlready = false;

    public Assumption(ControlFlowElement cfe, Symbol symbol) {
        Preconditions.checkState((cfe != null ? 1 : 0) != 0);
        Preconditions.checkState((symbol != null ? 1 : 0) != 0);
        this.assumptionGroup = new AssumptionGroup();
        this.assumptionGroup.add(this);
        this.creationSite = cfe;
        this.symbol = symbol;
        this.aliases.add(symbol);
    }

    public abstract Assumption copy();

    public Assumption(Assumption assumption) {
        this.assumptionGroup = assumption.assumptionGroup;
        this.assumptionGroup.add(this);
        this.creationSite = assumption.creationSite;
        this.symbol = assumption.symbol;
        this.aliases.addAll(assumption.aliases);
        this.dataFlowVisitor = assumption.dataFlowVisitor;
        this.guardsThatNeverHold.putAll(assumption.guardsThatNeverHold);
        this.guardsThatAlwaysHold.putAll(assumption.guardsThatAlwaysHold);
        this.failedBranches.addAll(assumption.failedBranches);
        this.passedBranches.addAll(assumption.passedBranches);
        this.terminatingGuard = assumption.terminatingGuard;
        this.openBranch = assumption.openBranch;
    }

    final void setDataFlowVisitor(DataFlowVisitor dataFlowVisitor) {
        this.dataFlowVisitor = dataFlowVisitor;
    }

    final Object getKey() {
        return this.assumptionGroup;
    }

    final void mergeWith(Assumption assumption) {
        if (assumption.mergedAlready) {
            return;
        }
        Preconditions.checkState((this.symbol == assumption.symbol ? 1 : 0) != 0);
        this.mergeData(assumption);
        this.assumptionGroup.remove(assumption);
        this.assumptionGroup.assure(this);
        assumption.mergedAlready = true;
        this.mergeClientData(assumption);
        this.checkAndFinalize();
    }

    final boolean isOpen() {
        return !this.isDone();
    }

    final boolean isDone() {
        return this.assumptionGroup.noCopies() && !this.openBranch;
    }

    final boolean isApplicable(Symbol sym) {
        if (this.isOpen()) {
            return this.aliases.contains(sym);
        }
        return false;
    }

    final boolean isFailed() {
        if (this.isDone()) {
            boolean guardsFailed;
            boolean branchFailed = !this.failedBranches.isEmpty();
            boolean bl = guardsFailed = this.terminatingGuard != null && this.terminatingGuard.type == PartialResult.Type.Failed;
            return branchFailed || guardsFailed;
        }
        return false;
    }

    final boolean isPassed() {
        if (this.isDone()) {
            boolean guardsPassed;
            boolean branchPassed = this.failedBranches.isEmpty();
            boolean bl = guardsPassed = this.terminatingGuard == null || this.terminatingGuard.type != PartialResult.Type.Failed;
            return branchPassed && guardsPassed;
        }
        return false;
    }

    final void remove() {
        this.assumptionGroup.remove(this);
    }

    final void callHoldsOnDataflow(Symbol lhs, Collection<Object> rhss) {
        Preconditions.checkState((boolean)this.isOpen());
        HashSet<PartialResult.Type> resultSet = new HashSet<PartialResult.Type>();
        for (Object rhs : rhss) {
            Symbol rSymbol = null;
            PartialResult result = null;
            if (rhs instanceof Symbol) {
                rSymbol = (Symbol)rhs;
                result = this.holdsOnDataflow(lhs, rSymbol, null);
                this.aliases.remove(lhs);
                if (rSymbol.isVariableSymbol() && this.followAliases()) {
                    this.aliases.add(rSymbol);
                }
            } else if (rhs instanceof Expression) {
                Expression rValue = (Expression)rhs;
                result = this.holdsOnDataflow(lhs, null, rValue);
            }
            if (result == null) continue;
            resultSet.add(result.type);
            this.handleHoldResult(result, lhs);
        }
        if (resultSet.size() > 1 && resultSet.contains((Object)PartialResult.Type.Unclear)) {
            this.openBranch = true;
        }
    }

    final void callHoldsOnEffect(EffectInfo effect, ControlFlowElement cfe) {
        Preconditions.checkState((boolean)this.isOpen());
        PartialResult holds = this.holdsOnEffect(effect, cfe);
        this.handleHoldResult(holds, effect.symbol);
        this.checkAndFinalize();
    }

    final void callHoldsOnGuards(Guard guard) {
        Preconditions.checkState((boolean)this.isOpen());
        switch (guard.asserts) {
            case AlwaysHolds: {
                this.guardsThatAlwaysHold.put((Object)guard.type, (Object)guard);
                break;
            }
            case NeverHolds: {
                this.guardsThatNeverHold.put((Object)guard.type, (Object)guard);
                break;
            }
        }
    }

    final void terminate() {
        this.beforeTermination();
        if (this.assumptionGroup.noCopies() && this.isOpen()) {
            this.openBranch = false;
            this.checkAndFinalize();
        }
    }

    final void checkAndFinalize() {
        if (this.assumptionGroup.noCopies()) {
            if (this.isOpen()) {
                this.finalizeGuards();
            }
            if (!this.isOpen() && this.isFailed()) {
                this.propagateFailed();
            }
        }
    }

    protected boolean followAliases() {
        return true;
    }

    protected void mergeClientData(Assumption assumption) {
    }

    protected PartialResult holdsOnDataflow(Symbol lhs, Symbol rSymbol, Expression rValue) {
        return PartialResult.Unclear;
    }

    protected PartialResult holdsOnEffect(EffectInfo effect, ControlFlowElement container) {
        return PartialResult.Unclear;
    }

    protected PartialResult holdsOnGuards(Multimap<GuardType, Guard> neverHolding, Multimap<GuardType, Guard> alwaysHolding) {
        return PartialResult.Unclear;
    }

    protected void beforeTermination() {
    }

    private void mergeData(Assumption assumption) {
        this.aliases.addAll(assumption.aliases);
        this.failedBranches.addAll(assumption.failedBranches);
        this.passedBranches.addAll(assumption.passedBranches);
        if (this.openBranch && assumption.openBranch) {
            this.guardsThatNeverHold.keySet().retainAll(assumption.guardsThatNeverHold.keySet());
            this.guardsThatAlwaysHold.keySet().retainAll(assumption.guardsThatAlwaysHold.keySet());
        } else if (assumption.openBranch) {
            this.guardsThatNeverHold.clear();
            this.guardsThatNeverHold.putAll(assumption.guardsThatNeverHold);
            this.guardsThatAlwaysHold.clear();
            this.guardsThatAlwaysHold.putAll(assumption.guardsThatAlwaysHold);
        }
        this.openBranch = this.openBranch || assumption.openBranch;
    }

    private void handleHoldResult(PartialResult result, Symbol lhs) {
        if (result.type == PartialResult.Type.Failed || result.type == PartialResult.Type.MayFailed) {
            this.failedBranches.add(result);
            this.aliases.remove(lhs);
        }
        if (result.type == PartialResult.Type.Passed) {
            this.passedBranches.add(result);
            this.aliases.remove(lhs);
        }
        if (this.aliases.isEmpty()) {
            this.openBranch = false;
        }
    }

    private void finalizeGuards() {
        PartialResult holds = this.holdsOnGuards(this.guardsThatNeverHold, this.guardsThatAlwaysHold);
        if (holds.type == PartialResult.Type.Passed) {
            this.terminatingGuard = holds;
            this.openBranch = false;
        }
        if (holds.type == PartialResult.Type.Failed) {
            this.terminatingGuard = holds;
            this.openBranch = false;
        }
        if (this.aliases.isEmpty()) {
            this.openBranch = false;
        }
    }

    private void propagateFailed() {
        if (this.dataFlowVisitor.failedAssumptions.containsKey(this.getParallelHash())) {
            Assumption failedParallel = this.dataFlowVisitor.failedAssumptions.get(this.getParallelHash());
            failedParallel.mergeData(this);
        } else {
            this.dataFlowVisitor.failedAssumptions.put(this.getParallelHash(), this);
        }
    }

    private int getParallelHash() {
        return Objects.hash(this.symbol, this.creationSite, this.getClass());
    }

    public String toString() {
        return String.valueOf(this.symbol.toString()) + " " + this.getClass().getSimpleName();
    }
}

