/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.Base;
import org.eclipse.wst.server.core.internal.IMemento;
import org.eclipse.wst.server.core.internal.ResourceManager;
import org.eclipse.wst.server.core.internal.RuntimeType;
import org.eclipse.wst.server.core.internal.RuntimeWorkingCopy;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.InternalInitializer;
import org.eclipse.wst.server.core.model.RuntimeDelegate;

public class Runtime
extends Base
implements IRuntime {
    protected static final String PROP_RUNTIME_TYPE_ID = "runtime-type-id";
    protected static final String PROP_LOCATION = "location";
    protected static final String PROP_TEST_ENVIRONMENT = "test-environment";
    protected static final String PROP_STUB = "stub";
    protected IRuntimeType runtimeType;
    protected RuntimeDelegate delegate;

    public Runtime(IFile file) {
        super(file);
    }

    public Runtime(IFile file, String id, IRuntimeType runtimeType) {
        super(file, id);
        this.runtimeType = runtimeType;
        this.map.put("name", runtimeType.getName());
    }

    public IRuntimeType getRuntimeType() {
        return this.runtimeType;
    }

    public IStatus validate(IProgressMonitor monitor) {
        try {
            return this.getDelegate(monitor).validate();
        }
        catch (Exception e) {
            ServerPlugin.logExtensionFailure(this.toString(), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RuntimeDelegate getDelegate(IProgressMonitor monitor) {
        if (this.delegate != null) {
            return this.delegate;
        }
        Runtime runtime = this;
        synchronized (runtime) {
            if (this.delegate == null) {
                try {
                    long time = System.currentTimeMillis();
                    this.delegate = ((RuntimeType)this.runtimeType).createRuntimeDelegate();
                    if (this.delegate != null) {
                        InternalInitializer.initializeRuntimeDelegate(this.delegate, this, monitor);
                    }
                    if (Trace.PERFORMANCE) {
                        Trace.trace("/performance", "Runtime.getDelegate(): <" + (System.currentTimeMillis() - time) + "> " + this.getRuntimeType().getId());
                    }
                }
                catch (Throwable t) {
                    ServerPlugin.logExtensionFailure(this.toString(), t);
                }
            }
        }
        return this.delegate;
    }

    public void dispose() {
        if (this.delegate != null) {
            this.delegate.dispose();
            this.delegate = null;
        }
    }

    public IRuntimeWorkingCopy createWorkingCopy() {
        return new RuntimeWorkingCopy(this);
    }

    public boolean isWorkingCopy() {
        return false;
    }

    public IPath getLocation() {
        String temp = this.getAttribute(PROP_LOCATION, (String)null);
        if (temp == null) {
            return null;
        }
        return new Path(temp);
    }

    protected void deleteFromMetadata() {
        ResourceManager.getInstance().removeRuntime(this);
    }

    protected void saveToMetadata(IProgressMonitor monitor) {
        super.saveToMetadata(monitor);
        ResourceManager.getInstance().addRuntime(this);
    }

    protected String getXMLRoot() {
        return "runtime";
    }

    public boolean isTestEnvironment() {
        return this.getAttribute(PROP_TEST_ENVIRONMENT, false);
    }

    public boolean isStub() {
        return this.getAttribute(PROP_STUB, false);
    }

    protected void setInternal(RuntimeWorkingCopy wc) {
        this.map = wc.map;
        this.runtimeType = wc.runtimeType;
        this.file = wc.file;
        this.delegate = wc.delegate;
    }

    protected void loadState(IMemento memento) {
        this.resolve();
    }

    protected void resolve() {
        String runtimeTypeId = this.getAttribute(PROP_RUNTIME_TYPE_ID, (String)null);
        this.runtimeType = runtimeTypeId != null ? ServerCore.findRuntimeType(runtimeTypeId) : null;
    }

    protected void saveState(IMemento memento) {
        if (this.runtimeType != null) {
            memento.putString(PROP_RUNTIME_TYPE_ID, this.runtimeType.getId());
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Runtime)) {
            return false;
        }
        Runtime runtime = (Runtime)obj;
        return runtime.getId().equals(this.getId());
    }

    public Object getAdapter(Class adapter) {
        if (this.delegate != null && adapter.isInstance(this.delegate)) {
            return this.delegate;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public Object loadAdapter(Class adapter, IProgressMonitor monitor) {
        this.getDelegate(monitor);
        if (adapter.isInstance(this.delegate)) {
            return this.delegate;
        }
        return Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
    }

    public String toString() {
        return "Runtime[" + this.getId() + ", " + this.getName() + ", " + this.getLocation() + ", " + this.getRuntimeType() + "]";
    }
}

