/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.json.ui.editor.syntaxcoloring;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.json.JSON.JSONPackage;
import org.eclipse.n4js.json.services.JSONGrammarAccess;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ide.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.ide.editor.syntaxcoloring.ISemanticHighlightingCalculator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;

public class JSONSemanticHighlightingCalculator
implements ISemanticHighlightingCalculator {
    @Inject
    private JSONGrammarAccess grammarAccess;

    public void provideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor, CancelIndicator cancelIndicator) {
        if (resource == null || resource.getParseResult() == null) {
            return;
        }
        ICompositeNode root = resource.getParseResult().getRootNode();
        for (INode node : root.getAsTreeIterable()) {
            EObject grammarElement = node.getGrammarElement();
            if (!(grammarElement instanceof RuleCall) || !(grammarElement.eContainer() instanceof Assignment) || ((RuleCall)grammarElement).getRule() != this.grammarAccess.getSTRINGRule()) continue;
            Assignment assignment = (Assignment)grammarElement.eContainer();
            if (assignment.getFeature().equals(JSONPackage.Literals.NAME_VALUE_PAIR__NAME.getName())) {
                acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"propertyName"});
                continue;
            }
            acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"string"});
        }
    }
}

