/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.accessModifiers;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.n4JS.FunctionOrFieldAccessor;
import org.eclipse.n4js.n4JS.N4ClassifierDefinition;
import org.eclipse.n4js.n4JS.N4JSASTUtils;
import org.eclipse.n4js.n4JS.N4TypeDefinition;
import org.eclipse.n4js.n4JS.NewExpression;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.SuperLiteral;
import org.eclipse.n4js.scoping.accessModifiers.TypeVisibilityChecker;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInTypeScope;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExprOrRef;
import org.eclipse.n4js.ts.typeRefs.ThisTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeTypeRef;
import org.eclipse.n4js.ts.typeRefs.UnionTypeExpression;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.MemberAccessModifier;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.TObjectPrototype;
import org.eclipse.n4js.ts.types.TStructuralType;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.util.AllSuperTypesCollector;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.typesystem.utils.TypeSystemHelper;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.util.Strings;

public class MemberVisibilityChecker {
    @Inject
    private TypeVisibilityChecker typeVisibilityChecker;
    @Inject
    private TypeSystemHelper tsh;

    public boolean isEnumLiteralVisible(EObject context, TypeRef enumType) {
        Resource contextResource = context.eResource();
        Type declaredReceiverType = this.getActualDeclaredReceiverType(context, enumType, contextResource.getResourceSet());
        return this.typeVisibilityChecker.isVisible((Resource)contextResource, (Type)declaredReceiverType).visibility;
    }

    public MemberVisibility isVisible(EObject context, TypeRef receiverType, TMember member) {
        boolean supercall = context instanceof ParameterizedPropertyAccessExpression && ((ParameterizedPropertyAccessExpression)context).getTarget() instanceof SuperLiteral;
        return this.isVisible(context, receiverType, member, supercall);
    }

    private MemberVisibility isVisible(EObject context, TypeRef receiverType, TMember member, boolean supercall) {
        Type declaredReceiverType;
        if (receiverType instanceof UnionTypeExpression) {
            for (TypeRef currUnitedTypeRef : ((UnionTypeExpression)receiverType).getTypeRefs()) {
                if (this.isVisible((EObject)context, (TypeRef)currUnitedTypeRef, (TMember)member, (boolean)supercall).visibility) continue;
                return new MemberVisibility(false);
            }
            return new MemberVisibility(true);
        }
        Resource contextResource = context.eResource();
        N4TypeDefinition typeDefiningContainer = (N4TypeDefinition)EcoreUtil2.getContainerOfType((EObject)context, N4TypeDefinition.class);
        Script script = (Script)EcoreUtil2.getContainerOfType((EObject)(typeDefiningContainer != null ? typeDefiningContainer : context), Script.class);
        Type contextType = null;
        TModule contextModule = script.getModule();
        if (typeDefiningContainer != null) {
            contextType = typeDefiningContainer.getDefinedType();
        }
        if ((declaredReceiverType = this.getActualDeclaredReceiverType(context, receiverType, contextResource.getResourceSet())) != null && this.typeVisibilityChecker.isVisible((Resource)contextResource, (Type)declaredReceiverType).visibility) {
            if (this.shortcutIsVisible(member, contextType, contextModule, declaredReceiverType)) {
                return new MemberVisibility(true);
            }
            return this.isVisible(contextModule, contextType, declaredReceiverType, member, supercall);
        }
        return new MemberVisibility(false);
    }

    public boolean isVisibleWhenOverriding(TModule contextModule, Type contextType, Type declaredReceiverType, TMember member) {
        if (member.getMemberAccessModifier() == MemberAccessModifier.PRIVATE) {
            return this.isModuleVisible(contextModule, member);
        }
        return this.isVisible((TModule)contextModule, (Type)contextType, (Type)declaredReceiverType, (TMember)member, (boolean)false).visibility;
    }

    private MemberVisibility isVisible(TModule contextModule, Type contextType, Type declaredReceiverType, TMember member, boolean supercall) {
        int startIndex = member.getMemberAccessModifier().getValue();
        boolean visibility = false;
        String firstVisible = "PUBLIC";
        int i = startIndex;
        while (i < MemberAccessModifier.values().length) {
            boolean visibilityForModifier = false;
            MemberAccessModifier modifier = MemberAccessModifier.get((int)i);
            switch (modifier) {
                case PRIVATE: {
                    visibilityForModifier = this.isModuleVisible(contextModule, member);
                    break;
                }
                case PROJECT: {
                    visibilityForModifier = this.isProjectVisible(contextModule, member);
                    break;
                }
                case PROTECTED_INTERNAL: {
                    visibilityForModifier = this.isProtectedInternalVisible(contextType, contextModule, declaredReceiverType, member, supercall);
                    break;
                }
                case PROTECTED: {
                    visibilityForModifier = this.isProtectedVisible(contextType, contextModule, declaredReceiverType, member, supercall);
                    break;
                }
                case PUBLIC_INTERNAL: {
                    visibilityForModifier = this.isPublicInternalVisible(contextType, contextModule, declaredReceiverType, member);
                    break;
                }
                case PUBLIC: {
                    visibilityForModifier = true;
                    break;
                }
            }
            if (i - startIndex < 1) {
                visibility = visibilityForModifier;
            }
            if (visibilityForModifier) {
                firstVisible = modifier.getName();
                break;
            }
            ++i;
        }
        return new MemberVisibility(visibility, firstVisible);
    }

    private Type getActualDeclaredReceiverType(EObject context, TypeRef receiverType, ResourceSet resourceSet) {
        ThisTypeRef thisTypeRef;
        if (receiverType instanceof TypeTypeRef) {
            RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment(context);
            return this.tsh.getStaticType(G, (TypeTypeRef)receiverType);
        }
        if (receiverType instanceof ThisTypeRef && (thisTypeRef = (ThisTypeRef)receiverType).isUseSiteStructuralTyping()) {
            FunctionOrFieldAccessor foa = N4JSASTUtils.getContainingFunctionOrAccessor((EObject)thisTypeRef);
            N4ClassifierDefinition classifier = (N4ClassifierDefinition)EcoreUtil2.getContainerOfType((EObject)foa, N4ClassifierDefinition.class);
            return classifier.getDefinedType();
        }
        if (receiverType instanceof FunctionTypeExprOrRef) {
            if (resourceSet == null) {
                return null;
            }
            BuiltInTypeScope builtInTypeScope = BuiltInTypeScope.get((ResourceSet)resourceSet);
            TObjectPrototype functionType = builtInTypeScope.getFunctionType();
            return functionType;
        }
        return receiverType.getDeclaredType();
    }

    private boolean shortcutIsVisible(TMember candidate, Type contextType, TModule contextModule, Type receiverType) {
        if (receiverType == contextType && contextType == candidate.eContainer()) {
            return true;
        }
        if (receiverType instanceof TStructuralType) {
            return true;
        }
        return contextModule == EcoreUtil2.getContainerOfType((EObject)candidate, TModule.class);
    }

    private boolean isPublicInternalVisible(Type contextType, TModule contextModule, Type declaredReceiverType, TMember member) {
        TModule receiverModule = (TModule)EcoreUtil2.getContainerOfType((EObject)member, TModule.class);
        return receiverModule == null || receiverModule == contextModule || Strings.equal((String)contextModule.getVendorID(), (String)receiverModule.getVendorID());
    }

    private boolean isProtectedVisible(Type contextType, TModule contextModule, Type declaredReceiverType, TMember member, boolean supercall) {
        if (this.isProjectVisible(contextModule, member)) {
            return true;
        }
        if (contextType == declaredReceiverType) {
            return true;
        }
        return this.isInternalCheckProtectedVisibile(contextType, contextModule, declaredReceiverType, member, supercall);
    }

    private boolean isInternalCheckProtectedVisibile(Type contextType, TModule contextModule, Type declaredReceiverType, TMember member, boolean supercall) {
        if (contextType == null) {
            return false;
        }
        List receiverSuperTypes = AllSuperTypesCollector.collect((ContainerType)((TClassifier)declaredReceiverType));
        if (!receiverSuperTypes.contains(contextType) && !supercall) {
            return false;
        }
        TClassifier memberClsfContainer = (TClassifier)EcoreUtil2.getContainerOfType((EObject)member, TClassifier.class);
        return declaredReceiverType instanceof TClassifier && receiverSuperTypes.contains(memberClsfContainer);
    }

    private boolean isProtectedInternalVisible(Type contextType, TModule contextModule, Type declaredReceiverType, TMember member, boolean supercall) {
        if (this.isProjectVisible(contextModule, member)) {
            return true;
        }
        if (contextType == declaredReceiverType) {
            return this.checkVendorEquality(contextModule, member);
        }
        if (this.isInternalCheckProtectedVisibile(contextType, contextModule, declaredReceiverType, member, supercall)) {
            return this.checkVendorEquality(contextModule, member);
        }
        return false;
    }

    private boolean checkVendorEquality(TModule contextModule, TMember member) {
        TModule memberModule = (TModule)EcoreUtil2.getContainerOfType((EObject)member, TModule.class);
        return memberModule == null || memberModule == contextModule || Strings.equal((String)contextModule.getVendorID(), (String)memberModule.getVendorID());
    }

    private boolean isProjectVisible(TModule contextModule, TMember member) {
        TModule memberModule = (TModule)EcoreUtil2.getContainerOfType((EObject)member, TModule.class);
        return memberModule == null || memberModule == contextModule || Strings.equal((String)memberModule.getProjectName(), (String)contextModule.getProjectName()) && Strings.equal((String)contextModule.getVendorID(), (String)memberModule.getVendorID()) || this.typeVisibilityChecker.isTestedProjectOf(contextModule, memberModule);
    }

    private boolean isModuleVisible(TModule contextModule, TMember member) {
        TModule memberModule = (TModule)EcoreUtil2.getContainerOfType((EObject)member, TModule.class);
        return memberModule != null && memberModule == contextModule;
    }

    public boolean isConstructorVisible(NewExpression context, TypeRef receiverType, TMethod ctorMethod) {
        return this.isVisible((EObject)context, (TypeRef)receiverType, (TMember)ctorMethod, (boolean)false).visibility;
    }

    public static class MemberVisibility {
        public final boolean visibility;
        public final String accessModifierSuggestion;

        MemberVisibility(boolean visibility) {
            this(visibility, null);
        }

        MemberVisibility(boolean visibility, String suggestion) {
            this.visibility = visibility;
            this.accessModifierSuggestion = suggestion;
        }
    }
}

