/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.ui.services;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.xpect.registry.DefaultBinding;
import org.eclipse.xtext.ui.validation.MarkerTypeProvider;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.Issue;

public class XtMarkerTypeProvider
extends MarkerTypeProvider {
    public static String MARKER_ID_SUCCESS = "org.eclipse.xpect.ui.live_test_execution_success";
    public static String MARKER_ID_FAIL = "org.eclipse.xpect.ui.live_test_execution_failed";
    public static String MARKER_ID_ERROR = "org.eclipse.xpect.ui.live_test_execution_error";
    public static String MARKER_ID_IGNORED = "org.eclipse.xpect.ui.live_test_execution_ignored";
    public static Set<String> MARKER_ALL = ImmutableSet.builder().add((Object)MARKER_ID_ERROR).add((Object)MARKER_ID_FAIL).add((Object)MARKER_ID_IGNORED).add((Object)MARKER_ID_SUCCESS).build();
    @Inject
    @DefaultBinding
    private MarkerTypeProvider delegate;

    public CheckType getCheckType(String markerType) {
        if (MARKER_ALL.contains(markerType)) {
            return CheckType.FAST;
        }
        return this.delegate.getCheckType(markerType);
    }

    public String getMarkerType(Issue issue) {
        String code = issue.getCode();
        if ("org.eclipse.xpect.live_test_execution.test_success".equals(code)) {
            return MARKER_ID_SUCCESS;
        }
        if ("org.eclipse.xpect.live_test_execution.test_ignore".equals(code)) {
            return MARKER_ID_IGNORED;
        }
        if ("org.eclipse.xpect.live_test_execution.test_fail".equals(code)) {
            return MARKER_ID_FAIL;
        }
        if ("org.eclipse.xpect.live_test_execution.test_error".equals(code)) {
            return MARKER_ID_ERROR;
        }
        return this.delegate.getMarkerType(issue);
    }
}

