/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.scoping.builtin;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInTypeScope;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInTypeScopeAccess;
import org.eclipse.n4js.ts.scoping.builtin.ExecutionEnvironmentDescriptor;
import org.eclipse.n4js.ts.scoping.builtin.N4Scheme;
import org.eclipse.xtext.resource.ClassloaderClasspathUriResolver;

@Singleton
public class BuiltInSchemeRegistrar
implements N4Scheme {
    private static final URI SAMPLE_URI = URI.createURI((String)"n4scheme:/unnecessary");
    @Inject
    private ClassLoader classLoader;

    public void registerScheme(ResourceSet builtInSchemeResourceSet) {
        URIConverter converter = builtInSchemeResourceSet.getURIConverter();
        if (this.registerScheme(converter, this.classLoader)) {
            ExecutionEnvironmentDescriptor descriptor = new ExecutionEnvironmentDescriptor(builtInSchemeResourceSet);
            this.register(builtInSchemeResourceSet, descriptor);
        }
    }

    public void registerScopes(ResourceSet targetResourceSet, ResourceSet builtInSchemeResourceSet) {
        BuiltInTypeScope typeScope = BuiltInTypeScope.get(builtInSchemeResourceSet);
        BuiltInTypeScopeAccess.registerBuiltInTypeScope(typeScope, targetResourceSet);
    }

    protected void register(ResourceSet builtInSchemeResourceSet, ExecutionEnvironmentDescriptor descriptor) {
        BuiltInTypeScope typeScope = new BuiltInTypeScope(descriptor);
        BuiltInTypeScopeAccess.registerBuiltInTypeScope(typeScope, builtInSchemeResourceSet);
    }

    public boolean registerScheme(URIConverter converter) {
        return this.registerScheme(converter, this.classLoader);
    }

    private boolean registerScheme(URIConverter converter, ClassLoader classLoader) {
        URIHandler uriHandler = (URIHandler)converter.getURIHandlers().get(0);
        if (uriHandler instanceof MyURIHandler || uriHandler.canHandle(SAMPLE_URI)) {
            return false;
        }
        converter.getURIHandlers().add(0, (Object)this.createURIHandler(classLoader, converter));
        return true;
    }

    private URIHandler createURIHandler(ClassLoader theClassLoader, URIConverter converter) {
        return new MyURIHandler(theClassLoader, converter);
    }

    public URIHandler createURIHandler(URIConverter converter) {
        return this.createURIHandler(this.classLoader, converter);
    }

    protected static class MyURIHandler
    extends URIHandlerImpl
    implements N4Scheme {
        private final ClassLoader classLoader;
        private final ClassloaderClasspathUriResolver uriResolver = new ClassloaderClasspathUriResolver();
        private final URIConverter original;

        public MyURIHandler(ClassLoader classLoader, URIConverter original) {
            this.classLoader = classLoader;
            this.original = original;
        }

        public boolean canHandle(URI uri) {
            return N4Scheme.isN4Scheme(uri);
        }

        public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
            URI classpathURI = N4Scheme.toClasspathURI(uri);
            URI resolvedURI = this.uriResolver.resolve((Object)this.classLoader, classpathURI);
            return this.original.createInputStream(resolvedURI, options);
        }
    }
}

