/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.binaries.nodejs;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.net.URI;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.n4js.binaries.BinariesConstants;
import org.eclipse.n4js.binaries.BinariesLocatorHelper;
import org.eclipse.n4js.binaries.BinariesValidator;
import org.eclipse.n4js.binaries.Binary;
import org.eclipse.n4js.semver.Semver.VersionNumber;
import org.eclipse.n4js.semver.model.SemverSerializer;
import org.eclipse.xtext.xbase.lib.Pair;

@Singleton
public class JavaBinary
extends Binary {
    private String memoizedCalculatedYarnPath = null;
    @Inject
    private BinariesValidator validator;
    @Inject
    private BinariesLocatorHelper binariesLocatorHelper;

    @Override
    public String getId() {
        return JavaBinary.class.getName();
    }

    @Override
    public String getLabel() {
        return "Java";
    }

    @Override
    public String getDescription() {
        return "Configuration of the folder location of the Yarn executable can be provided here. If not given, then the '" + this.getDefaultJavaPath() + "' location will be used as the default location. The required minimum version for Yarn is '" + SemverSerializer.serialize((VersionNumber)this.getMinimumVersion()) + "'.";
    }

    @Override
    public VersionNumber getMinimumVersion() {
        return BinariesConstants.JAVA_MIN_VERSION;
    }

    @Override
    public String getBinaryDirectory() {
        return this.getUserYarnPathOrDefault();
    }

    @Override
    public String getBinaryFileName() {
        return "java";
    }

    @Override
    public String getVersionArgument() {
        return "-version";
    }

    @Override
    public IStatus validate() {
        return this.validator.validate(this);
    }

    @Override
    public Optional<String[]> getCacheCleanCommand() {
        throw new UnsupportedOperationException("Not supported by Java binary");
    }

    @Override
    public String getNpmInstallCommand(boolean readPackagesFromPackageJson) {
        throw new UnsupportedOperationException("Not supported by Java binary");
    }

    @Override
    public String getNpmUninstallCommand() {
        throw new UnsupportedOperationException("Not supported by Java binary");
    }

    @Override
    public Optional<Pair<String, String>> getNpmSaveOptions() {
        throw new UnsupportedOperationException("Not supported by Java binary");
    }

    public String getUserYarnPathOrDefault() {
        URI userConfiguredLocation = this.getUserConfiguredLocation();
        return userConfiguredLocation == null ? this.getDefaultJavaPath() : new File(userConfiguredLocation).getAbsolutePath();
    }

    private String getDefaultJavaPath() {
        if (this.memoizedCalculatedYarnPath == null) {
            this.memoizedCalculatedYarnPath = this.binariesLocatorHelper.findJavaPath().toString();
        }
        return this.memoizedCalculatedYarnPath;
    }
}

