/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.utils;

import org.eclipse.n4js.scoping.utils.AbstractDescriptionWithError;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.xtext.resource.IEObjectDescription;

public class WrongStaticAccessDescription
extends AbstractDescriptionWithError {
    private final boolean staticAccess;

    public WrongStaticAccessDescription(IEObjectDescription delegate, boolean staticAccess) {
        super(delegate);
        this.staticAccess = staticAccess;
    }

    public String getMessage() {
        if (this.getEClass() == TypesPackage.eINSTANCE.getTypeVariable()) {
            return IssueCodes.getMessageForVIS_WRONG_TYPE_VARIABLE_ACCESSOR(this.getName());
        }
        String[] staticNonStatic = new String[]{"static", "non-static"};
        String staticMemberStr = staticNonStatic[this.staticAccess ? 1 : 0];
        String staticContextStr = staticNonStatic[this.staticAccess ? 0 : 1];
        return IssueCodes.getMessageForVIS_WRONG_STATIC_ACCESSOR(staticMemberStr, this.getName(), staticContextStr);
    }

    public String getIssueCode() {
        if (this.getEClass() == TypesPackage.eINSTANCE.getTypeVariable()) {
            return "VIS_WRONG_TYPE_VARIABLE_ACCESSOR";
        }
        return "VIS_WRONG_STATIC_ACCESSOR";
    }
}

