/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server;

import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.ide.validation.N4JSIssue;
import org.eclipse.n4js.ide.xtext.server.HashedFileContent;
import org.eclipse.n4js.ide.xtext.server.build.XIndexState;
import org.eclipse.n4js.ide.xtext.server.build.XSource2GeneratedMapping;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.resource.persistence.SerializableEObjectDescription;
import org.eclipse.xtext.resource.persistence.SerializableReferenceDescription;
import org.eclipse.xtext.resource.persistence.SerializableResourceDescription;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ProjectStatePersister {
    private static final int VERSION_1 = 1;
    private static final int CURRENT_VERSION = 1;
    public static final String FILENAME = ".n4js.projectstate";

    public void writeProjectState(IProjectConfig project, XIndexState state, Collection<? extends HashedFileContent> files, Map<URI, ? extends Collection<Issue>> validationIssues) {
        block11: {
            File file = this.getDataFile(project);
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (OutputStream nativeOut = Files.asByteSink((File)file, (FileWriteMode[])new FileWriteMode[0]).openBufferedStream();){
                    this.writeProjectState(nativeOut, N4JSLanguageUtils.getLanguageVersion(), state, files, validationIssues);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                if (!file.isFile()) break block11;
                file.delete();
            }
        }
    }

    public void writeProjectState(OutputStream stream, String languageVersion, XIndexState state, Collection<? extends HashedFileContent> files, Map<URI, ? extends Collection<Issue>> validationIssues) throws IOException {
        stream.write(1);
        Throwable throwable = null;
        Object var7_8 = null;
        try (ObjectOutputStream output = new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(stream, 8192)));){
            output.writeUTF(languageVersion);
            this.writeResourceDescriptions(state, output);
            this.writeFileMappings(state, output);
            this.writeFingerprints(files, output);
            this.writeValidationIssues(validationIssues, output);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void writeResourceDescriptions(XIndexState state, ObjectOutputStream output) throws IOException {
        ResourceDescriptionsData resourceDescriptionData = state.getResourceDescriptions();
        output.writeInt(resourceDescriptionData.getAllURIs().size());
        for (IResourceDescription description : resourceDescriptionData.getAllResourceDescriptions()) {
            if (description instanceof SerializableResourceDescription) {
                this.writeResourceDescription((SerializableResourceDescription)description, output);
                continue;
            }
            throw new IOException("Unexpected type: " + description.getClass().getName());
        }
    }

    private void writeResourceDescription(SerializableResourceDescription description, ObjectOutputStream output) throws IOException {
        output.writeUTF(description.getURI().toString());
        this.writeEObjectDescriptions(description, output);
        this.writeReferenceDescriptions(description, output);
        this.writeImportedNames(description, output);
    }

    private void writeImportedNames(SerializableResourceDescription resourceDescription, ObjectOutputStream output) throws IOException {
        List importedNames = IterableExtensions.toList((Iterable)resourceDescription.getImportedNames());
        output.writeInt(importedNames.size());
        for (QualifiedName importedName : importedNames) {
            this.writeQualifiedName(importedName, output);
        }
    }

    private void writeReferenceDescriptions(SerializableResourceDescription resourceDescription, ObjectOutputStream output) throws IOException {
        List references = resourceDescription.getReferences();
        output.writeInt(references.size());
        for (SerializableReferenceDescription reference : references) {
            output.writeUTF(reference.getSourceEObjectUri().toString());
            output.writeUTF(reference.getTargetEObjectUri().toString());
            output.writeUTF(reference.getContainerEObjectURI().toString());
            output.writeUTF(EcoreUtil.getURI((EObject)reference.getEReference()).toString());
            output.writeInt(reference.getIndexInList());
        }
    }

    private void writeEObjectDescriptions(SerializableResourceDescription resourceDescription, ObjectOutputStream output) throws IOException {
        List objects = resourceDescription.getDescriptions();
        output.writeInt(objects.size());
        for (SerializableEObjectDescription object : objects) {
            output.writeUTF(object.getEObjectURI().toString());
            output.writeUTF(EcoreUtil.getURI((EObject)object.getEClass()).toString());
            QualifiedName qn = object.getQualifiedName();
            this.writeQualifiedName(qn, output);
            HashMap userData = object.getUserData();
            if (userData != null) {
                output.writeInt(userData.size());
                for (Map.Entry entry : userData.entrySet()) {
                    output.writeUTF((String)entry.getKey());
                    this.writeUserDataValue((String)entry.getValue(), output);
                }
                continue;
            }
            output.writeInt(0);
        }
    }

    private void writeUserDataValue(String value, ObjectOutputStream output) throws IOException {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        output.writeInt(bytes.length);
        output.write(bytes);
    }

    private void writeQualifiedName(QualifiedName qualifiedName, ObjectOutputStream output) throws IOException {
        output.writeInt(qualifiedName.getSegmentCount());
        int i = 0;
        int max = qualifiedName.getSegmentCount();
        while (i < max) {
            output.writeUTF(qualifiedName.getSegment(i));
            ++i;
        }
    }

    private void writeFileMappings(XIndexState state, ObjectOutputStream output) throws IOException {
        state.getFileMappings().writeExternal(output);
    }

    private void writeFingerprints(Collection<? extends HashedFileContent> files, ObjectOutputStream output) throws IOException {
        output.writeInt(files.size());
        for (HashedFileContent hashedFileContent : files) {
            hashedFileContent.write(output);
        }
    }

    private void writeValidationIssues(Map<URI, ? extends Collection<Issue>> validationIssues, ObjectOutput output) throws IOException {
        int numberSources = validationIssues.size();
        output.writeInt(numberSources);
        for (Map.Entry<URI, ? extends Collection<Issue>> srcIssues : validationIssues.entrySet()) {
            URI source = srcIssues.getKey();
            Collection<Issue> issues = srcIssues.getValue();
            output.writeUTF(source.toString());
            ArrayList<N4JSIssue> n4Issues = new ArrayList<N4JSIssue>();
            for (Issue issue : issues) {
                if (issue instanceof N4JSIssue) {
                    n4Issues.add((N4JSIssue)issue);
                    continue;
                }
                n4Issues.add(new N4JSIssue(issue));
            }
            int numberIssues = n4Issues.size();
            output.writeInt(numberIssues);
            for (N4JSIssue issue : n4Issues) {
                issue.writeExternal(output);
            }
        }
    }

    public PersistedState readProjectState(IProjectConfig project) {
        block13: {
            File file = this.getDataFile(project);
            try {
                if (file.isFile()) {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (InputStream nativeIn = Files.asByteSource((File)file).openBufferedStream();){
                        PersistedState result = this.readProjectState(nativeIn, N4JSLanguageUtils.getLanguageVersion());
                        if (result == null && file.isFile()) {
                            file.delete();
                        }
                        return result;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            }
            catch (IOException | ClassNotFoundException e) {
                e.printStackTrace();
                if (!file.isFile()) break block13;
                file.delete();
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PersistedState readProjectState(InputStream stream, String expectedLanguageVersion) throws IOException, ClassNotFoundException {
        int version = stream.read();
        if (version != 1) {
            return null;
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (ObjectInputStream input = new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(stream, 8192)));){
            String languageVersion = input.readUTF();
            if (!expectedLanguageVersion.equals(languageVersion)) {
                return null;
            }
            ResourceDescriptionsData resourceDescriptionsData = this.readResourceDescriptions(input);
            XSource2GeneratedMapping fileMappings = this.readFileMappings(input);
            Map<URI, HashedFileContent> fingerprints = this.readFingerprints(input);
            Map<URI, Collection<Issue>> validationIssues = this.readValidationIssues(input);
            XIndexState indexState = new XIndexState(resourceDescriptionsData, fileMappings);
            return new PersistedState(indexState, fingerprints, validationIssues);
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    private ResourceDescriptionsData readResourceDescriptions(ObjectInputStream input) throws IOException {
        ArrayList<SerializableResourceDescription> descriptions = new ArrayList<SerializableResourceDescription>();
        int size = input.readInt();
        while (size > 0) {
            --size;
            descriptions.add(this.readResourceDescription(input));
        }
        return new ResourceDescriptionsData(descriptions);
    }

    private ENamedElement readEcoreElement(ObjectInputStream input) throws IOException {
        URI uri = URI.createURI((String)input.readUTF());
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(uri.trimFragment().toString());
        if (ePackage != null) {
            Resource resource = ePackage.eResource();
            return (ENamedElement)resource.getEObject(uri.fragment());
        }
        return null;
    }

    private SerializableResourceDescription readResourceDescription(ObjectInputStream input) throws IOException {
        SerializableResourceDescription result = new SerializableResourceDescription();
        result.setURI(URI.createURI((String)input.readUTF()));
        result.setDescriptions(this.readEObjectDescriptions(input));
        result.setReferences(this.readReferenceDescriptions(input));
        result.setImportedNames(this.readImportedNames(input));
        return result;
    }

    private List<QualifiedName> readImportedNames(ObjectInputStream input) throws IOException {
        int size = input.readInt();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<QualifiedName> result = new ArrayList<QualifiedName>(size);
        while (size > 0) {
            --size;
            result.add(this.readQualifiedName(input));
        }
        return result;
    }

    private List<SerializableReferenceDescription> readReferenceDescriptions(ObjectInputStream input) throws IOException {
        int size = input.readInt();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<SerializableReferenceDescription> result = new ArrayList<SerializableReferenceDescription>(size);
        while (size > 0) {
            --size;
            SerializableReferenceDescription reference = new SerializableReferenceDescription();
            reference.setSourceEObjectUri(URI.createURI((String)input.readUTF()));
            reference.setTargetEObjectUri(URI.createURI((String)input.readUTF()));
            reference.setContainerEObjectURI(URI.createURI((String)input.readUTF()));
            reference.setEReference((EReference)this.readEcoreElement(input));
            reference.setIndexInList(input.readInt() - 1);
            result.add(reference);
        }
        return result;
    }

    private List<SerializableEObjectDescription> readEObjectDescriptions(ObjectInputStream input) throws IOException {
        int size = input.readInt();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<SerializableEObjectDescription> result = new ArrayList<SerializableEObjectDescription>(size);
        while (size > 0) {
            --size;
            SerializableEObjectDescription object = new SerializableEObjectDescription();
            object.setEObjectURI(URI.createURI((String)input.readUTF()));
            object.setEClass((EClass)this.readEcoreElement(input));
            object.setQualifiedName(this.readQualifiedName(input));
            int userDataSize = input.readInt();
            HashMap<String, String> userData = new HashMap<String, String>();
            while (userDataSize > 0) {
                --userDataSize;
                String key = input.readUTF();
                userData.put(key, this.readUserDataValue(input));
            }
            object.setUserData(userData);
            result.add(object);
        }
        return result;
    }

    private String readUserDataValue(ObjectInputStream input) throws IOException {
        byte[] value = new byte[input.readInt()];
        input.readFully(value);
        return new String(value, StandardCharsets.UTF_8);
    }

    private QualifiedName readQualifiedName(ObjectInputStream input) throws IOException {
        int size = input.readInt();
        QualifiedName.Builder builder = new QualifiedName.Builder(size);
        while (size > 0) {
            --size;
            builder.add(input.readUTF());
        }
        return builder.build();
    }

    private XSource2GeneratedMapping readFileMappings(ObjectInputStream input) throws IOException, ClassNotFoundException {
        XSource2GeneratedMapping fileMappings = new XSource2GeneratedMapping();
        fileMappings.readExternal(input);
        return fileMappings;
    }

    private Map<URI, HashedFileContent> readFingerprints(ObjectInputStream input) throws IOException {
        int size = input.readInt();
        HashMap<URI, HashedFileContent> fingerprints = new HashMap<URI, HashedFileContent>(size);
        while (size > 0) {
            --size;
            HashedFileContent hashFileContent = new HashedFileContent(input);
            fingerprints.put(hashFileContent.getUri(), hashFileContent);
        }
        return fingerprints;
    }

    private Map<URI, Collection<Issue>> readValidationIssues(ObjectInputStream input) throws IOException, ClassNotFoundException {
        int numberOfSources = input.readInt();
        LinkedHashMap<URI, Collection<Issue>> validationIssues = new LinkedHashMap<URI, Collection<Issue>>(numberOfSources);
        while (numberOfSources > 0) {
            --numberOfSources;
            URI source = URI.createURI((String)input.readUTF());
            int numberOfIssues = input.readInt();
            validationIssues.put(source, new ArrayList(numberOfIssues));
            while (numberOfIssues > 0) {
                --numberOfIssues;
                N4JSIssue issue = new N4JSIssue();
                issue.readExternal(input);
                ((Collection)validationIssues.get(source)).add(issue);
            }
        }
        return validationIssues;
    }

    private File getDataFile(IProjectConfig project) {
        URI fileName = this.getFileName(project);
        File file = new File(fileName.toFileString());
        return file;
    }

    public URI getFileName(IProjectConfig project) {
        URI rootPath = project.getPath();
        return ((FileURI)new FileURI(rootPath).appendSegment(FILENAME)).toURI();
    }

    public static class PersistedState {
        public final XIndexState indexState;
        public final Map<URI, HashedFileContent> fileHashs;
        public final Map<URI, Collection<Issue>> validationIssues;

        PersistedState(XIndexState indexState, Map<URI, HashedFileContent> fileHashs, Map<URI, Collection<Issue>> validationIssues) {
            this.indexState = indexState;
            this.fileHashs = fileHashs;
            this.validationIssues = validationIssues;
        }
    }
}

