/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.n4idl;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.n4js.transpiler.Transformation;
import org.eclipse.n4js.transpiler.TranspilerState;
import org.eclipse.n4js.transpiler.es.EcmaScriptTranspiler;
import org.eclipse.n4js.transpiler.es.n4idl.N4IDLClassDeclarationTransformation;
import org.eclipse.n4js.transpiler.es.n4idl.N4IDLInterfaceDeclarationTransformation;
import org.eclipse.n4js.transpiler.es.n4idl.N4IDLMigrationTransformation;
import org.eclipse.n4js.transpiler.es.n4idl.N4IDLVersionedImportsTransformation;
import org.eclipse.n4js.transpiler.es.n4idl.N4IDLVersionedTypesTransformation;
import org.eclipse.n4js.transpiler.es.transform.ClassDeclarationTransformation;
import org.eclipse.n4js.transpiler.es.transform.InterfaceDeclarationTransformation;

public class N4IDLTranspiler
extends EcmaScriptTranspiler {
    @Inject
    private Provider<N4IDLVersionedImportsTransformation> versionedImportsTransformationProvider;
    @Inject
    private Provider<N4IDLVersionedTypesTransformation> versionedTypesTransformation;
    @Inject
    private Provider<N4IDLClassDeclarationTransformation> classDeclarationTransformation;
    @Inject
    private Provider<N4IDLInterfaceDeclarationTransformation> interfaceDeclarationTransformation;
    @Inject
    private Provider<N4IDLMigrationTransformation> migrationTransformation;

    @Override
    protected Transformation[] computeTransformationsToBeExecuted(TranspilerState state) {
        ArrayList<Transformation> transformations = new ArrayList<Transformation>(Arrays.asList(super.computeTransformationsToBeExecuted(state)));
        transformations.addAll(0, Arrays.asList((Transformation)this.versionedTypesTransformation.get(), (Transformation)this.versionedImportsTransformationProvider.get(), (Transformation)this.migrationTransformation.get()));
        transformations.replaceAll(t -> {
            if (t instanceof ClassDeclarationTransformation) {
                return (Transformation)this.classDeclarationTransformation.get();
            }
            if (t instanceof InterfaceDeclarationTransformation) {
                return (Transformation)this.interfaceDeclarationTransformation.get();
            }
            return t;
        });
        return transformations.toArray(new Transformation[0]);
    }
}

