/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.antlr.replacements;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.n4js.antlr.replacements.Replacements;

public class PlaceholderReplacer {
    private static final String SEPARATOR = "\n_________________________________REPLACE_WITH_________________________________\n";
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("##([^#]+)##");
    final Pattern searchPattern;
    final String replacement;
    private final String source;

    public PlaceholderReplacer(String replacementName) throws IOException {
        String replacementBase = Replacements.class.getPackage().getName().replace(".", "/");
        this.source = String.valueOf(replacementBase) + "/" + replacementName;
        URL url = Replacements.class.getClassLoader().getResource(this.source);
        if (url == null) {
            throw new NullPointerException("cannot replacement :: " + this.source);
        }
        String fileContents = Resources.toString((URL)url, (Charset)Charsets.UTF_8).replace("\r\n", "\n");
        String[] split = fileContents.split(SEPARATOR);
        String searchString = split[0];
        String replacementString = split[1];
        this.searchPattern = this.createPattern(searchString);
        this.replacement = this.createReplace(replacementString);
    }

    PlaceholderReplacer(String searchString, String replacementString) {
        this.source = "(dummy)";
        this.searchPattern = this.createPattern(searchString);
        this.replacement = this.createReplace(replacementString);
    }

    private Pattern createPattern(String match) {
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(match);
        int lastOffset = 0;
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            result.append(Pattern.quote(match.substring(lastOffset, matcher.start())));
            String regEx = matcher.group(1);
            result.append(regEx);
            lastOffset = matcher.end();
        }
        result.append(Pattern.quote(match.substring(lastOffset)));
        return Pattern.compile(result.toString());
    }

    private String createReplace(String match) {
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(match);
        int lastOffset = 0;
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            result.append(Matcher.quoteReplacement(match.substring(lastOffset, matcher.start())));
            String regEx = matcher.group(1);
            result.append(regEx);
            lastOffset = matcher.end();
        }
        result.append(Matcher.quoteReplacement(match.substring(lastOffset)));
        return result.toString();
    }

    public String toString() {
        return this.searchPattern + "\n" + SEPARATOR + "\n" + this.replacement;
    }

    public String replaceExactlyOnce(String original) {
        Matcher matcher = this.searchPattern.matcher(original);
        if (!matcher.find()) {
            String msg = "Pattern not found!\nTemplate:" + this.source + "\nPattern:\n" + this.searchPattern;
            throw new IllegalStateException(msg);
        }
        StringBuffer sb = new StringBuffer();
        matcher.appendReplacement(sb, this.replacement);
        if (matcher.find()) {
            String msg = "Pattern found more than once!\nTemplate:" + this.source + "\nPattern:\n" + this.searchPattern;
            throw new IllegalStateException(msg);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

