/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.building;

import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.ui.internal.N4JSEclipseProject;
import org.eclipse.n4js.ui.internal.ResourceUIValidatorExtension;
import org.eclipse.n4js.ui.projectModel.IN4JSEclipseCore;
import org.eclipse.n4js.utils.URIUtils;
import org.eclipse.xtext.builder.builderState.MarkerUpdaterImpl;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.ui.shared.contribution.ISharedStateContributionRegistry;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public class N4JSMarkerUpdater
extends MarkerUpdaterImpl {
    public static final boolean SHOW_ONLY_EXTERNAL_ERRORS = true;
    @Inject
    private IStorage2UriMapper mapper;
    private IN4JSEclipseCore n4jsCore;
    private ResourceUIValidatorExtension validatorExtension;

    @Inject
    private void injectISharedStateContributionRegistry(ISharedStateContributionRegistry registry) {
        try {
            this.n4jsCore = (IN4JSEclipseCore)registry.getSingleContributedInstance(IN4JSEclipseCore.class);
            this.validatorExtension = (ResourceUIValidatorExtension)((Object)registry.getSingleContributedInstance(ResourceUIValidatorExtension.class));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateMarkers(IResourceDescription.Delta delta, ResourceSet resourceSet, IProgressMonitor monitor) throws OperationCanceledException {
        Pair pair;
        IStorage storage;
        URI uri = delta.getUri();
        Iterable pairs = this.mapper.getStorages(uri);
        if (resourceSet != null && pairs.iterator().hasNext() && !((storage = (IStorage)(pair = (Pair)pairs.iterator().next()).getFirst()) instanceof IFile)) {
            this.updateMarkersForExternalLibraries(delta, resourceSet, monitor);
            return;
        }
        super.updateMarkers(delta, resourceSet, monitor);
    }

    private void updateMarkersForExternalLibraries(IResourceDescription.Delta delta, ResourceSet resourceSet, IProgressMonitor monitor) {
        IFile file;
        URI uri = delta.getUri();
        if (this.n4jsCore.isNoValidate(uri)) {
            return;
        }
        Resource resource = resourceSet.getResource(uri, true);
        IResourceValidator validator = this.getValidator(resource);
        IN4JSProject prj = (IN4JSProject)this.n4jsCore.findProject(uri).orNull();
        CancelIndicator cancelIndicator = this.getCancelIndicator(monitor);
        if (prj != null && prj.isExternal() && prj.exists() && prj instanceof N4JSEclipseProject && uri.isFile() && (file = URIUtils.convertFileUriToPlatformFile((URI)uri)) != null && resource != null) {
            List list = validator.validate(resource, CheckMode.NORMAL_AND_FAST, cancelIndicator);
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                if (((Issue)iter.next()).getSeverity() == Severity.ERROR) continue;
                iter.remove();
            }
            try {
                this.validatorExtension.createMarkers((IResource)file, resource, list);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private CancelIndicator getCancelIndicator(IProgressMonitor monitor) {
        return () -> monitor.isCanceled();
    }

    private IResourceValidator getValidator(Resource resource) {
        return this.getService(resource, IResourceValidator.class);
    }

    private <T> T getService(Resource resource, Class<T> clazz) {
        IResourceServiceProvider serviceProvider = ((XtextResource)resource).getResourceServiceProvider();
        return (T)serviceProvider.get(clazz);
    }
}

