/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.organize.imports;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.ImportSpecifier;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.NamespaceImportSpecifier;
import org.eclipse.n4js.ts.types.TExportableElement;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ImportsSorter {
    public static final void sortByImport(List<ImportDeclaration> declarations) {
        final HashMap bareImport2OriginalIndex = CollectionLiterals.newHashMap();
        Functions.Function1 _function = it -> it.isBare();
        Procedures.Procedure2 _function_1 = (decl, idx) -> bareImport2OriginalIndex.put(decl, idx);
        IterableExtensions.forEach((Iterable)IterableExtensions.filter(declarations, (Functions.Function1)_function), (Procedures.Procedure2)_function_1);
        declarations.sort(new Comparator<ImportDeclaration>(){

            @Override
            public int compare(ImportDeclaration o1, ImportDeclaration o2) {
                ImportSpecifier _get_1;
                int _xifexpression;
                int _xblockexpression = 0;
                int _compare = Boolean.compare(o1.isBare(), o2.isBare());
                int cmpBareness = _compare * -1;
                if (cmpBareness != 0) {
                    return cmpBareness;
                }
                boolean _isBare = o1.isBare();
                if (_isBare) {
                    return Integer.compare((Integer)bareImport2OriginalIndex.get(o1), (Integer)bareImport2OriginalIndex.get(o2));
                }
                int _switchResult = 0;
                ImportSpecifier _get = (ImportSpecifier)o1.getImportSpecifiers().get(0);
                boolean _matched = false;
                if (_get instanceof NamespaceImportSpecifier) {
                    _matched = true;
                    _xifexpression = 0;
                    _get_1 = (ImportSpecifier)o2.getImportSpecifiers().get(0);
                    _xifexpression = _get_1 instanceof NamespaceImportSpecifier ? ImportsSorter.compModules(o1, o2) : 1;
                    _switchResult = _xifexpression;
                }
                if (!_matched && _get instanceof NamedImportSpecifier) {
                    _matched = true;
                    _xifexpression = 0;
                    _get_1 = (ImportSpecifier)o2.getImportSpecifiers().get(0);
                    if (_get_1 instanceof NamespaceImportSpecifier) {
                        _xifexpression = -1;
                    } else {
                        int _xblockexpression_1 = 0;
                        int cmp = ImportsSorter.compModules(o1, o2);
                        int _xifexpression_1 = 0;
                        _xifexpression_1 = cmp == 0 ? ImportsSorter.compNamedImports((EList<ImportSpecifier>)o1.getImportSpecifiers(), (EList<ImportSpecifier>)o2.getImportSpecifiers()) : cmp;
                        _xifexpression = _xblockexpression_1 = _xifexpression_1;
                    }
                    _switchResult = _xifexpression;
                }
                if (!_matched) {
                    throw new UnsupportedOperationException("Unknown ImportSpecifier");
                }
                _xblockexpression = _switchResult;
                return _xblockexpression;
            }
        });
    }

    public static final void sortByName(List<ImportSpecifier> list) {
        Collections.sort(list, new Comparator<ImportSpecifier>(){

            @Override
            public int compare(ImportSpecifier o1, ImportSpecifier o2) {
                if (o1 instanceof NamespaceImportSpecifier) {
                    return 1;
                }
                if (o2 instanceof NamespaceImportSpecifier) {
                    return -1;
                }
                return ImportsSorter.compNamedImport((NamedImportSpecifier)o1, (NamedImportSpecifier)o2);
            }
        });
    }

    private static final int compNamedImports(EList<ImportSpecifier> l1, EList<ImportSpecifier> l2) {
        int comparable_elements = Math.min(l1.size(), l2.size());
        int i = 0;
        while (i < comparable_elements) {
            ImportSpecifier _get_1;
            ImportSpecifier _get = (ImportSpecifier)l1.get(i);
            int cmp = ImportsSorter.compNamedImport((NamedImportSpecifier)_get, (NamedImportSpecifier)(_get_1 = (ImportSpecifier)l2.get(i)));
            if (cmp != 0) {
                return cmp;
            }
            ++i;
        }
        int _size = l1.size();
        int _size_1 = l2.size();
        return _size - _size_1;
    }

    private static final int compNamedImport(NamedImportSpecifier o1, NamedImportSpecifier o2) {
        int _xblockexpression = 0;
        TExportableElement _importedElement = null;
        if (o1 != null) {
            _importedElement = o1.getImportedElement();
        }
        String _name = null;
        if (_importedElement != null) {
            _name = _importedElement.getName();
        }
        String name1 = _name;
        TExportableElement _importedElement_1 = null;
        if (o2 != null) {
            _importedElement_1 = o2.getImportedElement();
        }
        String _name_1 = null;
        if (_importedElement_1 != null) {
            _name_1 = _importedElement_1.getName();
        }
        String name2 = _name_1;
        String _elvis = null;
        _elvis = name1 != null ? name1 : "";
        String _elvis_1 = null;
        _elvis_1 = name2 != null ? name2 : "";
        int cmp1 = _elvis.compareTo(_elvis_1);
        int _xifexpression = 0;
        if (cmp1 == 0) {
            String _elvis_2 = null;
            String _alias = o1.getAlias();
            _elvis_2 = _alias != null ? _alias : "";
            String _elvis_3 = null;
            String _alias_1 = o2.getAlias();
            _elvis_3 = _alias_1 != null ? _alias_1 : "";
            _xifexpression = _elvis_2.compareTo(_elvis_3);
        } else {
            _xifexpression = cmp1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private static final int compModules(ImportDeclaration o1, ImportDeclaration o2) {
        String _elvis = null;
        String _qualifiedName = o1.getModule().getQualifiedName();
        _elvis = _qualifiedName != null ? _qualifiedName : "";
        String _elvis_1 = null;
        String _qualifiedName_1 = o2.getModule().getQualifiedName();
        _elvis_1 = _qualifiedName_1 != null ? _qualifiedName_1 : "";
        return _elvis.compareTo(_elvis_1);
    }
}

