/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.proposals.imports;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.resource.N4JSResourceDescriptionStrategy;
import org.eclipse.n4js.scoping.IContentAssistScopeProvider;
import org.eclipse.n4js.services.N4JSGrammarAccess;
import org.eclipse.n4js.ts.scoping.N4TSQualifiedNameProvider;
import org.eclipse.n4js.ts.typeRefs.TypeRefsPackage;
import org.eclipse.n4js.ts.types.TExportableElement;
import org.eclipse.n4js.ui.proposals.imports.N4JSReplacementTextApplier;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.impl.AliasedEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.util.Arrays;

public class ImportsAwareReferenceProposalCreator {
    @Inject
    private IScopeProvider scopeProvider;
    private IValueConverter<String> valueConverter;
    @Inject
    private N4JSReplacementTextApplier.Factory applierFactory;
    @Inject
    private IN4JSCore n4jsCore;
    private static final EReference[] referencesSupportingImportedElements = new EReference[]{N4JSPackage.Literals.IDENTIFIER_REF__ID, TypeRefsPackage.Literals.PARAMETERIZED_TYPE_REF__DECLARED_TYPE};

    @Inject
    private void setValueConverter(IValueConverterService service, N4JSGrammarAccess grammarAccess) {
        IValueConverter converter;
        this.valueConverter = converter = ((IValueConverterService.Introspectable)service).getConverter(grammarAccess.getTypeReferenceNameRule().getName());
    }

    public void lookupCrossReference(EObject model, EReference reference, ContentAssistContext context, ICompletionProposalAcceptor acceptor, Predicate<IEObjectDescription> filter, Function<IEObjectDescription, ICompletionProposal> proposalFactory) {
        if (model != null) {
            IContentAssistScopeProvider contentAssistScopeProvider = (IContentAssistScopeProvider)this.scopeProvider;
            IScope scope = contentAssistScopeProvider.getScopeForContentAssist(model, reference);
            Iterable candidates = scope.getAllElements();
            for (IEObjectDescription candidate : candidates) {
                if (!acceptor.canAcceptMoreProposals()) {
                    return;
                }
                if (!filter.apply((Object)candidate)) continue;
                QualifiedName qfn = candidate.getQualifiedName();
                int qfnSegmentCount = qfn.getSegmentCount();
                String tmodule = qfnSegmentCount >= 2 ? qfn.getSegment(qfnSegmentCount - 2) : null;
                ICompletionProposal proposal = this.getProposal(candidate, model, scope, reference, context, filter, proposalFactory);
                if (proposal instanceof ConfigurableCompletionProposal && candidate.getName().getSegmentCount() > 1) {
                    QualifiedName candidateName = this.getCandidateName(candidate, tmodule);
                    ConfigurableCompletionProposal castedProposal = (ConfigurableCompletionProposal)proposal;
                    castedProposal.setAdditionalData(N4JSReplacementTextApplier.KEY_QUALIFIED_NAME, (Object)candidateName);
                    castedProposal.setAdditionalData(N4JSReplacementTextApplier.KEY_ORIGINAL_QUALIFIED_NAME, (Object)qfn);
                }
                acceptor.accept(proposal);
            }
        }
    }

    private QualifiedName getCandidateName(IEObjectDescription candidate, String tmodule) {
        QualifiedName candidateName;
        IN4JSProject project = (IN4JSProject)this.n4jsCore.findProject(candidate.getEObjectURI()).orNull();
        if (project != null && tmodule != null && tmodule.equals(project.getMainModule())) {
            N4JSProjectName projectName = project.getProjectName();
            N4JSProjectName definesPackage = project.getDefinesPackageName();
            if (definesPackage != null) {
                projectName = definesPackage;
            }
            String lastSegmentOfQFN = candidate.getQualifiedName().getLastSegment().toString();
            candidateName = QualifiedName.create((String[])new String[]{projectName.getRawName(), lastSegmentOfQFN});
        } else {
            candidateName = candidate.getQualifiedName();
        }
        return candidateName;
    }

    private ICompletionProposal getProposal(IEObjectDescription candidate, EObject model, IScope scope, EReference reference, ContentAssistContext context, Predicate<IEObjectDescription> filter, Function<IEObjectDescription, ICompletionProposal> delegateProposalFactory) {
        IEObjectDescription inputToUse = this.getAliasedDescription(candidate, reference, context);
        ICompletionProposal result = (ICompletionProposal)delegateProposalFactory.apply((Object)inputToUse);
        if (result instanceof ConfigurableCompletionProposal) {
            N4JSReplacementTextApplier applier = this.applierFactory.create(model.eResource(), scope, this.valueConverter, filter, context.getViewer());
            ((ConfigurableCompletionProposal)result).setTextApplier((ConfigurableCompletionProposal.IReplacementTextApplier)applier);
        }
        return result;
    }

    private IEObjectDescription getAliasedDescription(IEObjectDescription candidate, EReference reference, ContentAssistContext context) {
        QualifiedName inputQN = candidate.getName();
        int inputNameSegmentCount = inputQN.getSegmentCount();
        if (inputNameSegmentCount > 1 && Arrays.contains((Object[])referencesSupportingImportedElements, (Object)reference)) {
            return new AliasedEObjectDescription(QualifiedName.create((String)inputQN.getLastSegment()), candidate);
        }
        if (inputNameSegmentCount == 2 && N4TSQualifiedNameProvider.GLOBAL_NAMESPACE_SEGMENT.equals(inputQN.getFirstSegment())) {
            return new AliasedEObjectDescription(QualifiedName.create((String)inputQN.getLastSegment()), candidate);
        }
        if (inputQN.getLastSegment().equals("default")) {
            if (TExportableElement.class.isAssignableFrom(candidate.getEClass().getInstanceClass()) && N4JSResourceDescriptionStrategy.getExportDefault((IEObjectDescription)candidate)) {
                return new AliasedEObjectDescription(inputQN, candidate);
            }
            QualifiedName nameNoDefault = inputQN.skipLast(1);
            QualifiedName moduleName = nameNoDefault.getSegmentCount() > 1 ? QualifiedName.create((String)nameNoDefault.getLastSegment()) : nameNoDefault;
            return new AliasedEObjectDescription(moduleName, candidate);
        }
        return candidate;
    }
}

