/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli.compiler;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.common.util.URI;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.n4js.ide.xtext.server.XWorkspaceManager;

@Singleton
public class IssueSerializer {
    @Inject
    XWorkspaceManager workspaceManager;

    public String diagnostics(Diagnostic diagnostic) {
        String position = String.format("%d:%d", diagnostic.getRange().getStart().getLine() + 1, diagnostic.getRange().getStart().getCharacter() + 1);
        String s = String.format("  %s %-8s %s", this.getShortSeverity(diagnostic.getSeverity()), position, diagnostic.getMessage());
        return s;
    }

    private String getShortSeverity(DiagnosticSeverity severity) {
        switch (severity) {
            case Error: {
                return "ERR";
            }
            case Warning: {
                return "WRN";
            }
            case Information: {
                return "INF";
            }
            case Hint: {
                return "HNT";
            }
        }
        return "???";
    }

    public String uri(String uri) {
        URI relativeUri = this.workspaceManager.makeWorkspaceRelative(URI.createURI((String)uri));
        return relativeUri.toFileString();
    }
}

