/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server.build;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.ide.xtext.server.build.XBuildContext;
import org.eclipse.n4js.ide.xtext.server.build.XBuildRequest;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.CompilerPhases;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.impl.AbstractResourceDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionDelta;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.resource.persistence.SerializableEObjectDescriptionProvider;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class XIndexer {
    @Inject
    private CompilerPhases compilerPhases;
    @Inject
    @Extension
    private OperationCanceledManager operationCanceledManager;

    public XIndexResult computeAndIndexAffected(XBuildRequest request, @Extension XBuildContext context) {
        ResourceDescriptionsData previousIndex = context.getOldState().getResourceDescriptions();
        ResourceDescriptionsData newIndex = request.getState().getResourceDescriptions();
        ArrayList<IResourceDescription.Delta> deltas = new ArrayList<IResourceDescription.Delta>();
        deltas.addAll(this.getDeltasForDeletedResources(request, previousIndex, context));
        deltas.addAll(this.getDeltasForChangedResources(request.getDirtyFiles(), previousIndex, context));
        for (IResourceDescription.Delta delta : deltas) {
            newIndex.register(delta);
        }
        HashSet<IResourceDescription.Delta> allDeltas = new HashSet<IResourceDescription.Delta>(deltas);
        allDeltas.addAll(request.getExternalDeltas());
        Set remainingURIs = IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)previousIndex.getAllResourceDescriptions(), IResourceDescription::getURI));
        remainingURIs.removeAll(ListExtensions.map(deltas, IResourceDescription.Delta::getUri));
        List allAffected = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)remainingURIs, it -> {
            IResourceDescription.Manager manager = context.getResourceServiceProvider((URI)it).getResourceDescriptionManager();
            IResourceDescription resourceDescription = previousIndex.getResourceDescription(it);
            return this.isAffected(resourceDescription, manager, allDeltas, allDeltas, (IResourceDescriptions)newIndex);
        }));
        deltas.addAll(this.getDeltasForChangedResources(allAffected, previousIndex, context));
        return new XIndexResult(deltas, newIndex);
    }

    protected List<IResourceDescription.Delta> getDeltasForDeletedResources(XBuildRequest request, ResourceDescriptionsData oldIndex, XBuildContext context) {
        ArrayList<IResourceDescription.Delta> deltas = new ArrayList<IResourceDescription.Delta>();
        for (URI deleted : request.getDeletedFiles()) {
            IResourceDescription oldDescription;
            IResourceServiceProvider resourceServiceProvider = context.getResourceServiceProvider(deleted);
            if (resourceServiceProvider == null) continue;
            this.operationCanceledManager.checkCanceled(context.getCancelIndicator());
            IResourceDescription iResourceDescription = oldDescription = oldIndex != null ? oldIndex.getResourceDescription(deleted) : null;
            if (oldDescription == null) continue;
            DefaultResourceDescriptionDelta delta = new DefaultResourceDescriptionDelta(oldDescription, null);
            deltas.add((IResourceDescription.Delta)delta);
        }
        return deltas;
    }

    protected List<IResourceDescription.Delta> getDeltasForChangedResources(Iterable<URI> affectedUris, ResourceDescriptionsData oldIndex, XBuildContext context) {
        try {
            this.compilerPhases.setIndexing((Notifier)context.getResourceSet(), true);
            ArrayList<IResourceDescription.Delta> result = new ArrayList<IResourceDescription.Delta>();
            for (IResourceDescription.Delta delta : context.executeClustered(affectedUris, it -> this.addToIndex((Resource)it, true, oldIndex, context))) {
                if (delta == null) continue;
                result.add(delta);
            }
            ArrayList<IResourceDescription.Delta> arrayList = result;
            return arrayList;
        }
        finally {
            this.compilerPhases.setIndexing((Notifier)context.getResourceSet(), false);
        }
    }

    protected IResourceDescription.Delta addToIndex(Resource resource, boolean isPreIndexing, ResourceDescriptionsData oldIndex, XBuildContext context) {
        this.operationCanceledManager.checkCanceled(context.getCancelIndicator());
        if (context.getResourceSet() != resource.getResourceSet()) {
            return null;
        }
        URI uri = resource.getURI();
        IResourceServiceProvider serviceProvider = context.getResourceServiceProvider(uri);
        IResourceDescription.Manager manager = serviceProvider.getResourceDescriptionManager();
        IResourceDescription newDescription = manager.getResourceDescription(resource);
        XResolvedResourceDescription toBeAdded = new XResolvedResourceDescription(newDescription);
        IResourceDescription.Delta delta = manager.createDelta(oldIndex != null ? oldIndex.getResourceDescription(uri) : null, (IResourceDescription)toBeAdded);
        return delta;
    }

    protected boolean isAffected(IResourceDescription affectionCandidate, IResourceDescription.Manager manager, Collection<IResourceDescription.Delta> newDeltas, Collection<IResourceDescription.Delta> allDeltas, IResourceDescriptions resourceDescriptions) {
        if (manager instanceof IResourceDescription.Manager.AllChangeAware) {
            return ((IResourceDescription.Manager.AllChangeAware)manager).isAffectedByAny(allDeltas, affectionCandidate, resourceDescriptions);
        }
        if (newDeltas.isEmpty()) {
            return false;
        }
        return manager.isAffected(newDeltas, affectionCandidate, resourceDescriptions);
    }

    public static class XIndexResult {
        private final List<IResourceDescription.Delta> resourceDeltas;
        private final ResourceDescriptionsData newIndex;

        public XIndexResult(List<IResourceDescription.Delta> resourceDeltas, ResourceDescriptionsData newIndex) {
            this.resourceDeltas = resourceDeltas;
            this.newIndex = newIndex;
        }

        public List<IResourceDescription.Delta> getResourceDeltas() {
            return this.resourceDeltas;
        }

        public ResourceDescriptionsData getNewIndex() {
            return this.newIndex;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = prime * result + (this.resourceDeltas == null ? 0 : this.resourceDeltas.hashCode());
            return prime * result + (this.newIndex == null ? 0 : this.newIndex.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            XIndexResult other = (XIndexResult)obj;
            if (this.resourceDeltas == null ? other.resourceDeltas != null : !this.resourceDeltas.equals(other.resourceDeltas)) {
                return false;
            }
            return !(this.newIndex == null ? other.newIndex != null : !this.newIndex.equals(other.newIndex));
        }

        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("resourceDeltas", this.resourceDeltas);
            b.add("newIndex", (Object)this.newIndex);
            return b.toString();
        }
    }

    protected static class XResolvedResourceDescription
    extends AbstractResourceDescription {
        private static final Logger LOG = Logger.getLogger(XResolvedResourceDescription.class);
        private URI URI;
        private ImmutableList<IEObjectDescription> exported;

        public XResolvedResourceDescription(IResourceDescription original) {
            this.URI = original.getURI();
            this.exported = ImmutableList.copyOf((Iterable)IterableExtensions.map((Iterable)original.getExportedObjects(), from -> {
                String[] userDataKeys;
                if (from instanceof SerializableEObjectDescriptionProvider) {
                    return ((SerializableEObjectDescriptionProvider)from).toSerializableEObjectDescription();
                }
                if (from.getEObjectOrProxy().eIsProxy()) {
                    return from;
                }
                InternalEObject result = (InternalEObject)EcoreUtil.create((EClass)from.getEClass());
                result.eSetProxyURI(from.getEObjectURI());
                HashMap userData = null;
                String[] stringArray = userDataKeys = from.getUserDataKeys();
                int n = userDataKeys.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    if (userData == null) {
                        userData = Maps.newHashMapWithExpectedSize((int)userDataKeys.length);
                    }
                    userData.put(key, from.getUserData(key));
                    ++n2;
                }
                return EObjectDescription.create((QualifiedName)from.getName(), (EObject)result, userData);
            }));
        }

        protected List<IEObjectDescription> computeExportedObjects() {
            return this.exported;
        }

        public Iterable<QualifiedName> getImportedNames() {
            IllegalStateException exception = new IllegalStateException("getImportedNames" + this.getURI());
            LOG.error((Object)exception, (Throwable)exception);
            return CollectionLiterals.emptyList();
        }

        public Iterable<IReferenceDescription> getReferenceDescriptions() {
            IllegalStateException exception = new IllegalStateException("getReferenceDescriptions" + this.getURI());
            LOG.error((Object)exception, (Throwable)exception);
            return CollectionLiterals.emptyList();
        }

        public URI getURI() {
            return this.URI;
        }
    }
}

