/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.factories;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.flowgraphs.ASTIterator;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.SymbolFactory;
import org.eclipse.n4js.flowgraphs.factories.CFEEffectInfos;
import org.eclipse.n4js.flowgraphs.factories.CFEFactoryDispatcher;
import org.eclipse.n4js.flowgraphs.factories.CFEMapper;
import org.eclipse.n4js.flowgraphs.model.ComplexNode;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.smith.Measurement;
import org.eclipse.n4js.smith.N4JSDataCollectors;

public class ReentrantASTIterator {
    static final String ASSERTION_MSG_AST_ORDER = "DelegatingNode or AST order erroneous";
    private final SymbolFactory symbolFactory;
    private final Set<ControlFlowElement> cfContainers;
    private final Map<ControlFlowElement, ComplexNode> cnMap;
    private final ASTIterator astIt;
    private final String scriptName;
    private int astPositionCounter = 0;

    ReentrantASTIterator(SymbolFactory symbolFactory, Set<ControlFlowElement> cfContainers, Map<ControlFlowElement, ComplexNode> cnMap, Script script) {
        this.symbolFactory = symbolFactory;
        this.cfContainers = cfContainers;
        this.cnMap = cnMap;
        this.astIt = new ASTIterator((EObject)script);
        this.scriptName = script.eResource().getURI().toString();
    }

    public void visitAll() {
        this.visitUtil(null);
    }

    public void visitUtil(ControlFlowElement termNode) {
        termNode = CFEMapper.map(termNode);
        while (this.astIt.hasNext()) {
            ComplexNode cn;
            ControlFlowElement mappedCFE;
            ControlFlowElement cfe = this.astIt.next();
            if (cfe != (mappedCFE = CFEMapper.map(cfe))) continue;
            if (mappedCFE != null && !this.cnMap.containsKey(mappedCFE) && (cn = CFEFactoryDispatcher.build(this, (EObject)mappedCFE)) != null) {
                Preconditions.checkState((this.astPositionCounter - 1 == cn.getExit().astPosition ? 1 : 0) != 0, (Object)ASSERTION_MSG_AST_ORDER);
                this.cfContainers.add(cn.getControlFlowContainer());
                this.cnMap.put(mappedCFE, cn);
                Throwable throwable = null;
                Object var6_7 = null;
                try (Measurement m = N4JSDataCollectors.dcAugmentEffectInfo.getMeasurement("AugmentEffectInfo_" + this.scriptName);){
                    CFEEffectInfos.set(this.symbolFactory, this.cnMap, cn, cfe);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            if (termNode != cfe && (termNode != mappedCFE || termNode == null)) continue;
            return;
        }
        Preconditions.checkState((termNode == null ? 1 : 0) != 0, (Object)ASSERTION_MSG_AST_ORDER);
    }

    public ControlFlowElement container() {
        return this.astIt.container();
    }

    public int pos() {
        return this.astPositionCounter++;
    }
}

