/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.preferences;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.n4js.external.ExternalLibraryHelper;
import org.eclipse.n4js.preferences.ExternalLibraryPreferenceModel;
import org.eclipse.n4js.preferences.ExternalLibraryPreferenceStore;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.utils.NodeModulesDiscoveryHelper;

abstract class ExternalLibraryPreferenceStoreImpl
implements ExternalLibraryPreferenceStore {
    private static final Logger LOGGER = Logger.getLogger(ExternalLibraryPreferenceStoreImpl.class);
    @Inject
    private ExternalLibraryHelper externalLibraryHelper;
    @Inject
    private NodeModulesDiscoveryHelper nodeModulesDiscoveryHelper;
    private final Collection<ExternalLibraryPreferenceStore.StoreUpdatedListener> listeners = Sets.newHashSet();
    private ExternalLibraryPreferenceModel model = this.getOrCreateModel();
    private ExternalLibraryPreferenceModel lastSavedModel;

    protected ExternalLibraryPreferenceStoreImpl() {
    }

    @Override
    public Collection<FileURI> getLocations() {
        ArrayList<FileURI> result = new ArrayList<FileURI>(this.getOrCreateModel().getExternalLibraryLocationsAsUris());
        return result;
    }

    @Override
    public Collection<FileURI> getNodeModulesLocations() {
        return this.getOrCreateModel().getNodeModulesLocationsAsUris();
    }

    @Override
    public void add(FileURI location) {
        this.getOrCreateModel().add(location);
    }

    @Override
    public void remove(FileURI location) {
        this.getOrCreateModel().remove(location);
    }

    @Override
    public void moveUp(FileURI location) {
        this.getOrCreateModel().moveUp(location);
    }

    @Override
    public void moveDown(FileURI location) {
        this.getOrCreateModel().moveDown(location);
    }

    @Override
    public void resetDefaults() {
        this.model = this.getDefaults();
    }

    @Override
    public void invalidate() {
        this.model = this.doLoad();
    }

    @Override
    public final IStatus save(IProgressMonitor monitor) {
        if (this.lastSavedModel != null && this.getOrCreateModel().equals(this.lastSavedModel)) {
            return new Status(0, "unknown", 2, "", null);
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IStatus status = this.doSave(this.getOrCreateModel());
        this.lastSavedModel = this.doLoad();
        if (status != null && status.isOK()) {
            this.notifyListeners(monitor);
        }
        return new Status(0, "unknown", 1, "", null);
    }

    @Override
    public void addListener(ExternalLibraryPreferenceStore.StoreUpdatedListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeListener(ExternalLibraryPreferenceStore.StoreUpdatedListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public IStatus synchronizeNodeModulesFolders() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        LinkedList<Path> projectRoots = new LinkedList<Path>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible()) {
                Path path = project.getLocation().toFile().toPath();
                projectRoots.add(path);
            }
            ++n2;
        }
        this.resetDefaults();
        List<Path> locations = this.nodeModulesDiscoveryHelper.findNodeModulesFolders(projectRoots);
        for (Path location : locations) {
            this.add(new FileURI(location.toFile()));
        }
        return this.save((IProgressMonitor)new NullProgressMonitor());
    }

    protected abstract IStatus doSave(ExternalLibraryPreferenceModel var1);

    protected abstract ExternalLibraryPreferenceModel doLoad();

    protected ExternalLibraryPreferenceModel getDefaults() {
        return ExternalLibraryPreferenceModel.createDefault();
    }

    protected void notifyListeners(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.listeners.size());
        for (ExternalLibraryPreferenceStore.StoreUpdatedListener listener : this.listeners) {
            listener.storeUpdated(this, (IProgressMonitor)subMonitor.newChild(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final ExternalLibraryPreferenceModel getOrCreateModel() {
        if (this.model != null) return this.model;
        Class<ExternalLibraryPreferenceStoreImpl> clazz = ExternalLibraryPreferenceStoreImpl.class;
        synchronized (ExternalLibraryPreferenceStoreImpl.class) {
            if (this.model != null) return this.model;
            this.model = this.doLoad();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.model;
        }
    }

    @Override
    public Iterable<FileURI> convertToProjectRootLocations(Iterable<FileURI> externalRootLocations) {
        return FluentIterable.from(externalRootLocations).transformAndConcat(this::getProjectsInLocation);
    }

    private final Iterable<FileURI> getProjectsInLocation(FileURI location) {
        if (this.isExistingFolder(location)) {
            Iterable<FileURI> directContents = this.getDirectProjectsInLocation(location);
            FluentIterable scopedContents = FluentIterable.from(this.getDirectoryContents(location)).filter(f1 -> this.isExistingFolder((FileURI)f1)).filter(f2 -> this.externalLibraryHelper.isScopeDirectory(f2.toJavaIoFile())).transformAndConcat(file -> this.getDirectProjectsInLocation((FileURI)file));
            return Iterables.concat((Iterable)scopedContents, directContents);
        }
        return Collections.emptyList();
    }

    private final Iterable<FileURI> getDirectProjectsInLocation(FileURI location) {
        if (this.isExistingFolder(location)) {
            return FluentIterable.from(this.getDirectoryContents(location)).filter(f -> this.isExistingFolder((FileURI)f)).filter(f -> this.externalLibraryHelper.isExternalProjectDirectory((SafeURI<?>)f));
        }
        return Collections.emptyList();
    }

    private final boolean isExistingFolder(FileURI file) {
        return file != null && file.isDirectory();
    }

    private final List<FileURI> getDirectoryContents(FileURI folder) {
        if (folder == null || !folder.isDirectory()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Not a directory: " + folder + "."));
            }
            return Collections.emptyList();
        }
        ArrayList fileList = Lists.newArrayList(folder.getChildren());
        Collections.sort(fileList, Comparator.comparing(SafeURI::toString));
        return fileList;
    }
}

