/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesystem.utils;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.ts.typeRefs.ComposedTypeRef;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsFactory;
import org.eclipse.n4js.ts.typeRefs.UnionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.UnknownTypeRef;
import org.eclipse.n4js.ts.utils.TypeCompareHelper;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.typesystem.utils.TypeSystemHelperStrategy;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

class SimplifyComputer
extends TypeSystemHelperStrategy {
    private static final UnknownTypeRef UNKNOWN_TYPE_REF = TypeRefsFactory.eINSTANCE.createUnknownTypeRef();
    @Inject
    private N4JSTypeSystem ts;
    @Inject
    private TypeCompareHelper typeCompareHelper;

    SimplifyComputer() {
    }

    public TypeRef createUnionType(RuleEnvironment G, TypeRef ... elements) {
        return this.simplify(G, TypeUtils.createNonSimplifiedUnionType((TypeRef[])elements));
    }

    public TypeRef createIntersectionType(RuleEnvironment G, TypeRef ... elements) {
        return this.simplify(G, TypeUtils.createNonSimplifiedIntersectionType((TypeRef[])elements));
    }

    public <T extends ComposedTypeRef> TypeRef simplify(RuleEnvironment G, T composedType) {
        List<TypeRef> typeRefs = this.getSimplifiedTypeRefs(G, composedType);
        int _size = typeRefs.size();
        switch (_size) {
            case 0: {
                return RuleEnvironmentExtensions.undefinedTypeRef(G);
            }
            case 1: {
                return (TypeRef)IterableExtensions.head(typeRefs);
            }
        }
        EClass eClass = composedType.eClass();
        EObject _create = EcoreUtil.create((EClass)eClass);
        ComposedTypeRef simplified = (ComposedTypeRef)_create;
        simplified.getTypeRefs().addAll(typeRefs);
        return simplified;
    }

    private <T extends ComposedTypeRef> List<TypeRef> getSimplifiedTypeRefs(RuleEnvironment G, T composedType) {
        if (composedType == null) {
            return null;
        }
        Iterable<TypeRef> typeRefsFlattened = this.flattenComposedTypes(composedType.eClass(), (TypeRef)composedType);
        List<TypeRef> typeRefsTrimmed = this.removeDuplicateAndTrivialTypes(G, typeRefsFlattened, composedType);
        List<TypeRef> typeRefsSimplified = this.simplifyBasedOnSubtypeRelations(G, typeRefsTrimmed, composedType);
        return typeRefsSimplified;
    }

    private Iterable<TypeRef> flattenComposedTypes(EClass eClass, TypeRef typeRef) {
        Iterable<Object> _xifexpression = null;
        boolean _isInstance = eClass.isInstance((Object)typeRef);
        if (_isInstance) {
            Functions.Function1 _function = it -> this.flattenComposedTypes(eClass, (TypeRef)it);
            _xifexpression = Iterables.concat((Iterable)ListExtensions.map((List)((ComposedTypeRef)typeRef).getTypeRefs(), (Functions.Function1)_function));
        } else {
            _xifexpression = Collections.singleton(typeRef);
        }
        return _xifexpression;
    }

    private List<TypeRef> removeDuplicateAndTrivialTypes(RuleEnvironment G, Iterable<TypeRef> typeRefs, ComposedTypeRef composedType) {
        boolean haveOthers;
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        Comparator _typeRefComparator = this.typeCompareHelper.getTypeRefComparator();
        TreeSet set = new TreeSet(_typeRefComparator);
        Iterables.addAll(set, typeRefs);
        boolean _isEmpty = set.isEmpty();
        if (_isEmpty) {
            return Collections.emptyList();
        }
        int _size = set.size();
        boolean bl = _tripleEquals = _size == 1;
        if (_tripleEquals) {
            return Collections.singletonList((TypeRef)IterableExtensions.head(set));
        }
        set.remove(UNKNOWN_TYPE_REF);
        int _size_1 = set.size();
        boolean bl2 = _tripleEquals_1 = _size_1 == 1;
        if (_tripleEquals_1) {
            return Collections.singletonList((TypeRef)IterableExtensions.head(set));
        }
        ParameterizedTypeRef anyTypeRef = RuleEnvironmentExtensions.anyTypeRef(G);
        ParameterizedTypeRef objectTypeRef = RuleEnvironmentExtensions.objectTypeRef(G);
        ParameterizedTypeRef nullTypeRef = RuleEnvironmentExtensions.nullTypeRef(G);
        ParameterizedTypeRef undefinedTypeRef = RuleEnvironmentExtensions.undefinedTypeRef(G);
        boolean haveAny = set.remove(anyTypeRef);
        boolean haveObject = set.remove(objectTypeRef);
        boolean haveNull = set.remove(nullTypeRef);
        boolean haveUndefined = set.remove(undefinedTypeRef);
        boolean _isEmpty_1 = set.isEmpty();
        boolean bl3 = haveOthers = !_isEmpty_1;
        if (composedType instanceof UnionTypeExpression) {
            if (haveAny) {
                return Collections.singletonList(anyTypeRef);
            }
            if (haveObject && !haveOthers) {
                return Collections.singletonList(objectTypeRef);
            }
            if (!haveOthers) {
                if (haveNull) {
                    return Collections.singletonList(nullTypeRef);
                }
                if (haveUndefined) {
                    return Collections.singletonList(undefinedTypeRef);
                }
                throw new IllegalStateException();
            }
        } else {
            if (haveUndefined) {
                return Collections.singletonList(undefinedTypeRef);
            }
            if (haveNull && !haveOthers) {
                return Collections.singletonList(nullTypeRef);
            }
            if (!haveOthers) {
                if (haveObject) {
                    return Collections.singletonList(objectTypeRef);
                }
                if (haveAny) {
                    return Collections.singletonList(anyTypeRef);
                }
                throw new IllegalStateException();
            }
        }
        int _size_2 = set.size();
        int _plus = _size_2 + 2;
        ArrayList<TypeRef> typeRefsCleaned = new ArrayList<TypeRef>(_plus);
        for (TypeRef e : set) {
            TypeRef cpy = (TypeRef)TypeUtils.copyIfContained((EObject)e);
            typeRefsCleaned.add(cpy);
        }
        if (haveObject) {
            typeRefsCleaned.add((TypeRef)objectTypeRef);
        }
        return typeRefsCleaned;
    }

    private List<TypeRef> simplifyBasedOnSubtypeRelations(RuleEnvironment G, List<TypeRef> typeRefs, ComposedTypeRef composedType) {
        boolean _tripleEquals;
        int _size = typeRefs.size();
        boolean bl = _tripleEquals = _size == 2;
        if (_tripleEquals) {
            boolean isStructural;
            TypeRef fst = typeRefs.get(0);
            TypeRef snd = typeRefs.get(1);
            boolean bl2 = isStructural = fst.isUseSiteStructuralTyping() || fst.isDefSiteStructuralTyping() || snd.isUseSiteStructuralTyping() || snd.isDefSiteStructuralTyping();
            if (!isStructural) {
                boolean _subtypeSucceeded = this.ts.subtypeSucceeded(G, (TypeArgument)fst, (TypeArgument)snd);
                if (_subtypeSucceeded) {
                    if (composedType instanceof UnionTypeExpression) {
                        return Collections.singletonList(snd);
                    }
                    return Collections.singletonList(fst);
                }
                boolean _subtypeSucceeded_1 = this.ts.subtypeSucceeded(G, (TypeArgument)snd, (TypeArgument)fst);
                if (_subtypeSucceeded_1) {
                    if (composedType instanceof UnionTypeExpression) {
                        return Collections.singletonList(fst);
                    }
                    return Collections.singletonList(snd);
                }
            }
        }
        return typeRefs;
    }
}

