/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.handler;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.n4js.ui.utils.HandlerServiceUtils;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class FileExtensionBasedPropertTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        String uri;
        IFile file;
        Object element;
        AtomicReference<IFile> fileRef = new AtomicReference<IFile>();
        if (receiver instanceof Iterable) {
            Iterable itr = (Iterable)receiver;
            if (!Iterables.isEmpty((Iterable)itr)) {
                element = Iterables.get((Iterable)itr, (int)0);
                if (element instanceof IFile) {
                    fileRef.set((IFile)element);
                } else if (element instanceof ITextSelection) {
                    fileRef.set(this.tryGetFileFromActiveEditor());
                }
            }
        } else if (receiver.getClass().isArray()) {
            Object[] array = (Object[])receiver;
            if (array.length > 0 && array[0] instanceof IFile) {
                element = array[0];
                if (element instanceof IFile) {
                    fileRef.set((IFile)element);
                } else if (element instanceof ITextSelection) {
                    fileRef.set(this.tryGetFileFromActiveEditor());
                }
            }
        } else if (receiver instanceof IFile) {
            fileRef.set((IFile)receiver);
        } else if (receiver instanceof IFileEditorInput) {
            fileRef.set(((IFileEditorInput)receiver).getFile());
        } else if (receiver instanceof ITextSelection) {
            fileRef.set(this.tryGetFileFromActiveEditor());
        }
        Collection<String> expectedFileExtensions = this.getExpectedFileExtensions(expectedValue);
        if (fileRef.get() != null && (file = (IFile)fileRef.get()).exists() && (uri = String.valueOf(file.getLocationURI())).contains(".")) {
            return expectedFileExtensions.contains(uri.substring(uri.lastIndexOf(".") + 1));
        }
        return false;
    }

    private Collection<String> getExpectedFileExtensions(Object expectedValue) {
        if (expectedValue == null) {
            return Collections.emptyList();
        }
        if (expectedValue instanceof String) {
            return ImmutableSet.copyOf((Iterable)Splitter.on((String)",").trimResults().split((CharSequence)String.valueOf(expectedValue)));
        }
        if (expectedValue.getClass().isArray()) {
            Object[] values = (Object[])expectedValue;
            ImmutableSet.Builder builder = ImmutableSet.builder();
            int i = 0;
            while (i < values.length) {
                if (values[i] instanceof String) {
                    builder.addAll(this.getExpectedFileExtensions(values[i]));
                }
                ++i;
            }
            return builder.build();
        }
        if (expectedValue instanceof Iterable) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            FluentIterable.from((Iterable)((Iterable)expectedValue)).filter(String.class).transform(str -> this.getExpectedFileExtensions(str)).forEach(t -> {
                ImmutableSet.Builder builder2 = builder.addAll((Iterable)t);
            });
            return builder.build();
        }
        return Collections.emptyList();
    }

    private IFile tryGetFileFromActiveEditor() {
        Optional<IEditorPart> editor = HandlerServiceUtils.getActiveEditor();
        if (editor.isPresent() && ((IEditorPart)editor.get()).getEditorInput() instanceof IFileEditorInput) {
            return ((IFileEditorInput)((IEditorPart)editor.get()).getEditorInput()).getFile();
        }
        return null;
    }
}

