/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.model;

import com.google.inject.Singleton;
import org.eclipse.xtext.ui.editor.model.ITokenTypeToPartitionTypeMapper;
import org.eclipse.xtext.ui.editor.model.ITokenTypeToPartitionTypeMapperExtension;
import org.eclipse.xtext.ui.editor.model.TokenTypeToStringMapper;

@Singleton
public class TerminalsTokenTypeToPartitionMapper
extends TokenTypeToStringMapper
implements ITokenTypeToPartitionTypeMapper,
ITokenTypeToPartitionTypeMapperExtension {
    public static final String COMMENT_PARTITION = "__comment";
    public static final String SL_COMMENT_PARTITION = "__sl_comment";
    public static final String STRING_LITERAL_PARTITION = "__string";
    protected static final String[] SUPPORTED_PARTITIONS = new String[]{"__comment", "__sl_comment", "__string", "__dftl_partition_content_type"};

    @Override
    public String getPartitionType(int antlrTokenType) {
        if (antlrTokenType == 0) {
            return "__dftl_partition_content_type";
        }
        return this.getMappedValue(antlrTokenType);
    }

    @Override
    protected String calculateId(String tokenName, int tokenType) {
        if ("RULE_ML_COMMENT".equals(tokenName)) {
            return COMMENT_PARTITION;
        }
        if ("RULE_SL_COMMENT".equals(tokenName)) {
            return SL_COMMENT_PARTITION;
        }
        if ("RULE_STRING".equals(tokenName)) {
            return STRING_LITERAL_PARTITION;
        }
        return "__dftl_partition_content_type";
    }

    @Override
    public String[] getSupportedPartitionTypes() {
        return SUPPORTED_PARTITIONS;
    }

    @Override
    public boolean isMultiLineComment(String partitionType) {
        return COMMENT_PARTITION.equals(partitionType);
    }

    @Override
    public boolean isSingleLineComment(String partitionType) {
        return SL_COMMENT_PARTITION.equals(partitionType);
    }
}

