/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.expectation.impl;

import com.google.common.base.Joiner;
import org.eclipse.xpect.XpectArgument;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.expectation.IStringExpectation;
import org.eclipse.xpect.expectation.StringExpectation;
import org.eclipse.xpect.expectation.impl.AbstractExpectation;
import org.eclipse.xpect.expectation.impl.ExpectationRegionProvider;
import org.eclipse.xpect.expectation.impl.TargetSyntaxSupport;
import org.eclipse.xpect.setup.XpectSetupFactory;
import org.eclipse.xpect.state.Creates;
import org.eclipse.xpect.text.Text;
import org.eclipse.xtext.util.internal.FormattingMigrator;
import org.junit.ComparisonFailure;

@XpectSetupFactory
@XpectImport(value={ExpectationRegionProvider.class})
public class StringExpectationImpl
extends AbstractExpectation
implements IStringExpectation {
    private final StringExpectation annotation;

    public StringExpectationImpl(XpectArgument argument, TargetSyntaxSupport targetSyntax) {
        super(argument, targetSyntax);
        this.annotation = argument.getAnnotationOrDefault(StringExpectation.class);
    }

    @Override
    public void assertEquals(Object string) {
        String migratedExpectation;
        if (string == null) {
            throw new NullPointerException("Object is null");
        }
        String originalExpectation = this.getExpectation();
        String nl = new Text(originalExpectation).getNL();
        String actual = string.toString();
        String actualWithNL = Joiner.on((String)nl).join(new Text(actual).splitIntoLines());
        String escapedActual = this.getTargetSyntaxLiteral().escape(actualWithNL);
        if (this.annotation.whitespaceSensitive()) {
            migratedExpectation = this.annotation.newLineCharacterSensitive() ? originalExpectation : originalExpectation.replaceAll("\\r?\\n", "\n");
        } else {
            FormattingMigrator migrator = new FormattingMigrator();
            migratedExpectation = migrator.migrate(escapedActual, originalExpectation);
        }
        if (this.annotation.caseSensitive() && !migratedExpectation.equals(escapedActual) || !this.annotation.caseSensitive() && !migratedExpectation.equalsIgnoreCase(escapedActual)) {
            String expDoc = this.replaceInDocument(migratedExpectation);
            String actDoc = this.replaceInDocument(escapedActual);
            throw new ComparisonFailure("", expDoc, actDoc);
        }
    }

    public StringExpectation getAnnotation() {
        return this.annotation;
    }

    @Creates
    public IStringExpectation create() {
        return this;
    }
}

