/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server.concurrent;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.eclipse.n4js.ide.xtext.server.concurrent.XCancellable;
import org.eclipse.n4js.ide.xtext.server.concurrent.XRequestCancelIndicator;
import org.eclipse.n4js.ide.xtext.server.concurrent.XRequestManager;

public abstract class XAbstractRequest<V>
implements Runnable,
XCancellable {
    private static final Logger LOG = Logger.getLogger(XAbstractRequest.class);
    private static final AtomicInteger counter = new AtomicInteger(1);
    protected final ResultFuture result;
    protected final XRequestCancelIndicator cancelIndicator;
    protected final XRequestManager requestManager;
    protected final String description;

    protected XAbstractRequest(XRequestManager requestManager, String description) {
        this.requestManager = requestManager;
        this.description = String.valueOf(this.getClass().getSimpleName()) + "[" + description + "#" + counter.getAndIncrement() + "]";
        this.result = new ResultFuture();
        this.cancelIndicator = new XRequestCancelIndicator(this);
    }

    public String toString() {
        if (this.result.isCancelled()) {
            return "(cancelled)" + this.description;
        }
        if (this.result.isDone()) {
            return "(done)" + this.description;
        }
        return this.description;
    }

    void cancelResult() {
        this.result.doCancel();
    }

    boolean isDone() {
        return this.result.isDone();
    }

    void complete(V value) {
        this.result.complete(value);
    }

    void completeExceptionally(Throwable t) {
        if (!this.requestManager.isCancelException(t)) {
            LOG.error((Object)"Error during request: ", t);
            this.result.completeExceptionally(t);
        } else {
            this.cancelResult();
        }
    }

    @Override
    public void cancel() {
        this.cancelIndicator.doCancel();
    }

    public CompletableFuture<V> get() {
        return this.result;
    }

    private class ResultFuture
    extends CompletableFuture<V> {
        private ResultFuture() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            XAbstractRequest.this.cancel();
            return this.isCancelled();
        }

        void doCancel() {
            super.cancel(true);
        }
    }
}

