/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.runner.extension;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.n4js.runner.IRunner;
import org.eclipse.n4js.runner.RunConfiguration;
import org.eclipse.n4js.runner.extension.EclipseRunnerDescriptor;
import org.eclipse.n4js.runner.extension.IRunnerDescriptor;

@Singleton
public class RunnerRegistry {
    private static final Logger log = Logger.getLogger(RunnerRegistry.class);
    public static final String RUNNERS_EXTENSION_POINT_ID = "org.eclipse.n4js.runner.runners";
    private final Map<String, IRunnerDescriptor> descriptors = new HashMap<String, IRunnerDescriptor>();
    private boolean isInitialized = false;
    @Inject
    private Injector injector;

    public void register(IRunnerDescriptor runnerDescriptor) {
        String runnerId = runnerDescriptor.getId();
        if (this.descriptors.containsKey(runnerId)) {
            throw new IllegalArgumentException("cannot register two runners with the same ID: " + runnerId);
        }
        this.descriptors.put(runnerId, runnerDescriptor);
    }

    public boolean isRegistered(String runnerId) {
        return this.getDescriptors().get(runnerId) != null;
    }

    public Map<String, IRunnerDescriptor> getDescriptors() {
        if (!this.isInitialized) {
            this.initialize();
        }
        return Collections.unmodifiableMap(this.descriptors);
    }

    public IRunnerDescriptor getDescriptor(String runnerId) {
        IRunnerDescriptor result = this.getDescriptors().get(runnerId);
        if (result == null) {
            throw new IllegalArgumentException("no runner found for ID: " + runnerId);
        }
        return result;
    }

    public IRunner getRunner(String runnerId) {
        return this.getDescriptor(runnerId).getRunner();
    }

    public IRunner getRunner(RunConfiguration runConfig) {
        String runnerId = runConfig.getRunnerId();
        if (runnerId == null || runnerId.trim().isEmpty()) {
            throw new IllegalArgumentException("no runner ID defined in given run configuration");
        }
        return this.getRunner(runnerId);
    }

    private void initialize() {
        if (this.isInitialized) {
            throw new IllegalStateException("may invoke method initialize() only once");
        }
        this.isInitialized = true;
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        if (registry != null) {
            IConfigurationElement[] configElems;
            IConfigurationElement[] iConfigurationElementArray = configElems = registry.getConfigurationElementsFor(RUNNERS_EXTENSION_POINT_ID);
            int n = configElems.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement elem = iConfigurationElementArray[n2];
                try {
                    EclipseRunnerDescriptor descriptor = new EclipseRunnerDescriptor(elem);
                    this.injector.injectMembers((Object)descriptor);
                    this.register(descriptor);
                }
                catch (Exception ex) {
                    log.error((Object)"Error while reading extensions for extension point org.eclipse.n4js.runner.runners", (Throwable)ex);
                }
                ++n2;
            }
        }
    }

    public void reset() {
        this.isInitialized = false;
        this.descriptors.clear();
    }
}

