/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping;

import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.scoping.accessModifiers.TypeVisibilityChecker;
import org.eclipse.n4js.scoping.accessModifiers.VariableVisibilityChecker;
import org.eclipse.n4js.scoping.accessModifiers.VisibilityAwareIdentifiableScope;
import org.eclipse.n4js.scoping.accessModifiers.VisibilityAwareTypeScope;
import org.eclipse.n4js.scoping.utils.CanLoadFromDescriptionHelper;
import org.eclipse.n4js.scoping.utils.UserDataAwareScope;
import org.eclipse.n4js.ts.scoping.builtin.DefaultN4GlobalScopeProvider;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.resource.containers.FilterUriContainer;
import org.eclipse.xtext.scoping.IScope;

public class N4JSGlobalScopeProvider
extends DefaultN4GlobalScopeProvider {
    @Inject
    private TypeVisibilityChecker typeVisibilityChecker;
    @Inject
    private VariableVisibilityChecker varVisibilityChecker;
    @Inject
    private CanLoadFromDescriptionHelper canLoadFromDescriptionHelper;

    protected IScope createContainerScope(IScope parent, IContainer container, Predicate<IEObjectDescription> filter, EClass type, boolean ignoreCase) {
        throw new UnsupportedOperationException();
    }

    protected IScope getScope(IScope parent, Resource context, boolean ignoreCase, EClass type, Predicate<IEObjectDescription> filter) {
        Object result = null;
        try {
            result = super.getScope(parent, context, ignoreCase, type, filter);
        }
        catch (IllegalStateException ise) {
            String msg = "ERROR for " + context.getURI() + " ::\n" + Throwables.getStackTraceAsString((Throwable)ise);
            System.err.println(msg);
            return IScope.NULLSCOPE;
        }
        if (this.isSubtypeOfType(type)) {
            result = new VisibilityAwareTypeScope((IScope)result, this.typeVisibilityChecker, context);
            return result;
        }
        if (this.isSubtypeOfIdentifiable(type)) {
            result = new VisibilityAwareIdentifiableScope((IScope)result, this.varVisibilityChecker, this.typeVisibilityChecker, context);
            return result;
        }
        return result;
    }

    protected boolean isSubtypeOfIdentifiable(EClass type) {
        return type == TypesPackage.Literals.IDENTIFIABLE_ELEMENT || type.getEPackage() == TypesPackage.eINSTANCE && TypesPackage.Literals.IDENTIFIABLE_ELEMENT.isSuperTypeOf(type);
    }

    protected IScope createContainerScopeWithContext(Resource resource, IScope parent, IContainer container, Predicate<IEObjectDescription> filter, EClass type, boolean ignoreCase) {
        if (resource != null) {
            URI uriToFilter = resource.getURI();
            if (container.hasResourceDescription(uriToFilter) && !N4JSGlobalScopeProvider.isStaticPolyFiller(resource)) {
                container = new FilterUriContainer(uriToFilter, container);
            }
            IScope result = UserDataAwareScope.createScope(parent, (ISelectable)container, filter, type, ignoreCase, resource.getResourceSet(), this.canLoadFromDescriptionHelper, container);
            return result;
        }
        return IScope.NULLSCOPE;
    }

    private static final boolean isStaticPolyFiller(Resource resource) {
        if (resource instanceof N4JSResource) {
            return ((N4JSResource)resource).getModule().isStaticPolyfillModule();
        }
        return false;
    }
}

