/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.model;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.eclipse.n4js.flowgraphs.ControlFlowType;
import org.eclipse.n4js.flowgraphs.model.Node;

public abstract class AbstractEdge {
    public final Node start;
    public final Node end;
    public final ControlFlowType cfType;
    private final int cachedHash;

    public AbstractEdge(Node start, Node end, ControlFlowType cfType) {
        Preconditions.checkState((start != null ? 1 : 0) != 0, (Object)"Start node must not be null");
        Preconditions.checkState((end != null ? 1 : 0) != 0, (Object)"End node must not be null");
        Preconditions.checkState((start != end ? 1 : 0) != 0, (Object)"Edge must not have same Start/End nodes");
        this.start = start;
        this.end = end;
        this.cfType = cfType;
        this.cachedHash = Objects.hash(new Object[]{start, end, cfType});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractEdge)) {
            return false;
        }
        AbstractEdge edge = (AbstractEdge)obj;
        boolean equals = true;
        equals &= this.start.id == edge.start.id;
        equals &= this.end.id == edge.end.id;
        return equals &= this.cfType == edge.cfType;
    }

    public int hashCode() {
        return this.cachedHash;
    }
}

