/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.runner;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.fileextensions.FileExtensionType;
import org.eclipse.n4js.fileextensions.FileExtensionsRegistry;
import org.eclipse.n4js.generator.AbstractSubGenerator;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.runner.IExecutor;
import org.eclipse.n4js.runner.IRunner;
import org.eclipse.n4js.runner.RunConfiguration;
import org.eclipse.n4js.runner.RunnerHelper;
import org.eclipse.n4js.runner.extension.IRunnerDescriptor;
import org.eclipse.n4js.runner.extension.RunnerRegistry;
import org.eclipse.n4js.utils.ResourceNameComputer;

@Singleton
public class RunnerFrontEnd {
    @Inject
    private IN4JSCore in4jscore;
    @Inject
    private ResourceNameComputer resourceNameComputer;
    @Inject
    private RunnerHelper runnerHelper;
    @Inject
    private RunnerRegistry runnerRegistry;
    @Inject
    private FileExtensionsRegistry fileExtensionsRegistry;

    public boolean canRun(String runnerId, URI moduleToRun) {
        throw new UnsupportedOperationException();
    }

    public RunConfiguration createConfiguration(String runnerId, URI moduleToRun) {
        return this.createConfiguration(runnerId, null, moduleToRun);
    }

    public RunConfiguration createConfiguration(String runnerId, N4JSProjectName implementationId, URI moduleToRun) {
        IRunnerDescriptor runnerDesc = this.runnerRegistry.getDescriptor(runnerId);
        IRunner runner = runnerDesc.getRunner();
        RunConfiguration config = runner.createConfiguration();
        config.setName(this.runnerHelper.computeConfigurationName(runnerId, moduleToRun));
        config.setRunnerId(runnerId);
        config.setRuntimeEnvironment(runnerDesc.getEnvironment());
        config.setImplementationId(implementationId);
        config.setUserSelection(moduleToRun);
        this.computeDerivedValues(config);
        return config;
    }

    public RunConfiguration createConfiguration(String runnerId, N4JSProjectName implementationId, URI moduleToRun, String additionalPath) {
        RunConfiguration runConfig = this.createConfiguration(runnerId, implementationId, moduleToRun);
        runConfig.addAdditionalPath(additionalPath);
        return runConfig;
    }

    public RunConfiguration createConfiguration(Map<String, Object> values) {
        String runnerId = RunConfiguration.getString(values, "RUNNER_ID", false);
        IRunner runner = this.runnerRegistry.getRunner(runnerId);
        RunConfiguration config = runner.createConfiguration();
        config.writePersistentValues(values);
        this.computeDerivedValues(config);
        return config;
    }

    public RunConfiguration createXpectOutputTestConfiguration(String runnerId, String userSelectionNodePathResolvableTargetFileName, Path additionalProjectPath, N4JSProjectName additionalProjectName) {
        IRunnerDescriptor runnerDesc = this.runnerRegistry.getDescriptor(runnerId);
        IRunner runner = runnerDesc.getRunner();
        RunConfiguration config = runner.createConfiguration();
        config.setName(String.valueOf(runnerId) + "__" + userSelectionNodePathResolvableTargetFileName);
        config.setRuntimeEnvironment(runnerDesc.getEnvironment());
        config.setImplementationId(null);
        config.setRunnerId(runnerId);
        config.setCoreProjectPaths((Map<Path, N4JSProjectName>)ImmutableMap.of((Object)additionalProjectPath, (Object)additionalProjectName));
        config.setWorkingDirectory(additionalProjectPath);
        config.setFileToRun(Paths.get(userSelectionNodePathResolvableTargetFileName, new String[0]));
        config.setExecutionData("userSelection", userSelectionNodePathResolvableTargetFileName);
        IRunner preparedRunner = this.runnerRegistry.getRunner(runnerId);
        preparedRunner.prepareConfiguration(config);
        return config;
    }

    public void computeDerivedValues(RunConfiguration config) {
        this.computeDerivedValues(config, true);
    }

    public void computeDerivedValues(RunConfiguration config, boolean delegateToRunnerCustomization) {
        this.configureWorkingDirectory(config);
        this.configureFileToRun(config);
        this.configureDependenciesAndPaths(config);
        this.configureExecutionData(config);
        if (delegateToRunnerCustomization) {
            IRunner runner = this.runnerRegistry.getRunner(config);
            runner.prepareConfiguration(config);
        }
    }

    private void configureWorkingDirectory(RunConfiguration config) {
        URI userSelection = config.getUserSelection();
        if (userSelection != null) {
            IN4JSProject containingProject = this.resolveProject(userSelection);
            Path workingDirectory = containingProject.getLocation().toFileSystemPath();
            config.setWorkingDirectory(workingDirectory);
        }
    }

    private void configureFileToRun(RunConfiguration config) {
        URI userSelection = config.getUserSelection();
        if (userSelection != null && this.hasValidFileExtension(userSelection.toString())) {
            String selectedFileDescriptor = this.resourceNameComputer.generateFileDescriptor(userSelection, null);
            Path selectedFilePath = new File(selectedFileDescriptor).toPath();
            IN4JSProject containingProject = this.resolveProject(userSelection);
            String outputPathStr = containingProject.getOutputPath();
            Path outputPath = Paths.get(outputPathStr.replace('/', File.separatorChar), new String[0]);
            Path fileToRun = outputPath.resolve(selectedFilePath);
            config.setFileToRun(fileToRun);
        } else {
            config.setFileToRun(null);
        }
    }

    private void configureDependenciesAndPaths(RunConfiguration config) {
        RunnerHelper.ApiUsage apiUsage = this.runnerHelper.getProjectExtendedDepsAndApiImplMapping(config.getRuntimeEnvironment(), config.getUserSelection(), config.getImplementationId() != null ? config.getImplementationId() : null, true);
        List<IN4JSProject> deps = apiUsage.projects;
        Map<IN4JSProject, IN4JSProject> apiImplProjectMapping = apiUsage.concreteApiImplProjectMapping;
        config.setApiImplProjectMappingFromProjects(apiImplProjectMapping);
        Set depsImpl = deps.stream().map(p -> {
            IN4JSProject p2 = (IN4JSProject)apiImplProjectMapping.get(p);
            IN4JSProject p3 = p2 != null ? p2 : p;
            return p3;
        }).collect(Collectors.toCollection(() -> Sets.newLinkedHashSet()));
        Map<Path, N4JSProjectName> coreProjectPaths = this.runnerHelper.getCoreProjectPaths(depsImpl);
        config.setCoreProjectPaths(coreProjectPaths);
    }

    private void configureExecutionData(RunConfiguration config) {
        URI userSelection = config.getUserSelection();
        if (userSelection != null && this.hasValidFileExtension(userSelection.toString())) {
            String userSelection_targetFileName = this.resourceNameComputer.generateFileDescriptor(userSelection, null);
            IN4JSProject project = this.resolveProject(userSelection);
            String base = AbstractSubGenerator.calculateProjectBasedOutputDirectory((IN4JSProject)project, (boolean)true);
            config.setExecutionData("userSelection", String.valueOf(base) + "/" + userSelection_targetFileName);
        } else {
            config.setExecutionData("userSelection", null);
        }
        config.setExecutionData("projectNameMapping", config.getApiImplProjectMapping());
    }

    private IN4JSProject resolveProject(URI n4jsSourceURI) {
        Optional optionalProject = this.in4jscore.findProject(n4jsSourceURI);
        if (!optionalProject.isPresent()) {
            throw new RuntimeException("Cannot handle resource without containing project. Resource URI was: " + n4jsSourceURI + ".");
        }
        return (IN4JSProject)optionalProject.get();
    }

    private boolean hasValidFileExtension(String fileName) {
        for (String fileExtension : this.fileExtensionsRegistry.getFileExtensions(FileExtensionType.RUNNABLE_FILE_EXTENSION)) {
            if (!fileName.endsWith("." + fileExtension)) continue;
            return true;
        }
        return false;
    }

    public Process run(String runnerId, N4JSProjectName implementationId, URI moduleToRun) throws ExecutionException {
        return this.run(this.createConfiguration(runnerId, implementationId, moduleToRun));
    }

    public Process run(RunConfiguration config) throws ExecutionException {
        return this.run(config, this.createDefaultExecutor());
    }

    public Process run(RunConfiguration config, IExecutor executor) throws ExecutionException {
        return this.runnerRegistry.getRunner(config).run(config, executor);
    }

    public IExecutor createDefaultExecutor() {
        return new IExecutor(){

            @Override
            public Process exec(String[] cmdLine, File workingDirectory, Map<String, String> envp) throws ExecutionException {
                ProcessBuilder pb = new ProcessBuilder(cmdLine);
                pb.environment().putAll(envp);
                pb.directory(workingDirectory);
                pb.inheritIO();
                String errFile = System.getProperty("org.eclipse.n4js.runner.RunnerFrontEnd.ERRORFILE", "");
                String outFile = System.getProperty("org.eclipse.n4js.runner.RunnerFrontEnd.OUTPUTFILE", "");
                if (errFile != null && errFile.length() > 0) {
                    pb.redirectError(ProcessBuilder.Redirect.to(new File(errFile)));
                }
                if (outFile != null && outFile.length() > 0) {
                    pb.redirectOutput(ProcessBuilder.Redirect.to(new File(outFile)));
                }
                try {
                    return pb.start();
                }
                catch (IOException e) {
                    throw new ExecutionException(e);
                }
            }
        };
    }
}

