/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tests.builder;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.N4JSUiInjectorProvider;
import org.eclipse.n4js.external.LibraryManager;
import org.eclipse.n4js.tests.builder.BuilderUtil;
import org.eclipse.n4js.tests.builder.TestedN4JSWorkspace;
import org.eclipse.n4js.tests.util.EclipseGracefulUIShutdownEnabler;
import org.eclipse.n4js.tests.util.EclipseUIUtils;
import org.eclipse.n4js.tests.util.ProjectTestsHelper;
import org.eclipse.n4js.tests.util.ProjectTestsUtils;
import org.eclipse.n4js.ui.building.ResourceDescriptionWithoutModuleUserData;
import org.eclipse.n4js.ui.internal.N4JSActivator;
import org.eclipse.n4js.ui.utils.AutobuildUtils;
import org.eclipse.n4js.utils.process.ProcessResult;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.xtext.builder.impl.QueuedBuildData;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.testing.InjectWith;
import org.eclipse.xtext.testing.XtextRunner;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.ui.testing.util.IResourcesSetupUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.runner.RunWith;

@RunWith(value=XtextRunner.class)
@InjectWith(value=N4JSUiInjectorProvider.class)
public abstract class AbstractBuilderTest {
    private static final Logger LOGGER = Logger.getLogger(AbstractBuilderTest.class);
    @Inject
    protected LibraryManager libraryManager;
    @Inject
    private IResourceSetProvider resourceSetProvider;
    @Inject
    private ResourceDescriptionsProvider resourceDescriptionsProvider;
    @Inject
    private ProjectTestsHelper projectTestsHelper;
    @Inject
    @Rule
    public TestedN4JSWorkspace testedWorkspace;
    @Inject
    private QueuedBuildData queuedBuildData;

    static {
        EclipseGracefulUIShutdownEnabler.enableOnce();
    }

    @Before
    public final void setUp() throws Exception {
        IIntroManager introManager;
        IResourcesSetupUtil.cleanWorkspace();
        IResourcesSetupUtil.cleanBuild();
        this.waitForAutoBuild();
        if (this.checkForCleanWorkspace()) {
            StringBuilder error;
            if (IResourcesSetupUtil.root().getProjects().length != 0 && IResourcesSetupUtil.root().getProjects(8).length != 0) {
                error = new StringBuilder();
                this.tryCleanWorkspace(error);
                IProject[] iProjectArray = IResourcesSetupUtil.root().getProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    error.append(project.getName());
                    error.append("\n");
                    ++n2;
                }
                Assert.assertEquals((Object)"", (Object)error.toString());
            }
            if (BuilderUtil.countResourcesInIndex() != 0) {
                error = new StringBuilder();
                this.tryCleanXtextIndex(error);
                for (IResourceDescription desc : BuilderUtil.getBuilderState().getAllResourceDescriptions()) {
                    error.append(desc.getURI());
                    error.append("\n");
                }
                Assert.assertEquals((Object)"", (Object)error.toString());
            }
        }
        if (PlatformUI.isWorkbenchRunning() && (introManager = PlatformUI.getWorkbench().getIntroManager()).getIntro() != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    introManager.closeIntro(introManager.getIntro());
                }
            });
        }
    }

    private void tryCleanXtextIndex(StringBuilder error) {
        try {
            try {
                LOGGER.info((Object)"Xtext index was not empty. Trying to clean up index...");
                this.turnOffAutobuild();
                this.tryCleanWorkspace(error);
                this.cleanBuild();
                LOGGER.info((Object)"Index clean up finished.");
            }
            catch (CoreException e) {
                throw new IllegalStateException("Error while performing clean build.", e);
            }
        }
        finally {
            this.turnOnAutobuild();
            this.waitForAutoBuild();
        }
    }

    private void tryCleanWorkspace(StringBuilder error) {
        AbstractBuilderTest.deleteProjects(IResourcesSetupUtil.root().getProjects(), error);
        AbstractBuilderTest.deleteProjects(IResourcesSetupUtil.root().getProjects(8), error);
    }

    private void turnOffAutobuild() {
        this.toggleAutobuild(false);
    }

    private void turnOnAutobuild() {
        this.toggleAutobuild(true);
    }

    private void toggleAutobuild(boolean enable) {
        AutobuildUtils.set((boolean)enable);
    }

    private static void deleteProjects(IProject[] projects, StringBuilder error) {
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.exists()) {
                try {
                    project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    error.append(e.getMessage());
                }
            }
            ++n2;
        }
    }

    protected boolean checkForCleanWorkspace() {
        return true;
    }

    @After
    public final void tearDown() throws Exception {
        this.libraryManager.deleteAllNodeModulesFolders((IProgressMonitor)new NullProgressMonitor());
        this.closeAllEditorsForTearDown();
        ProjectTestsUtils.closeAllProjectsInWorkspace();
        this.testedWorkspace.cleanBuild();
        IResourcesSetupUtil.cleanWorkspace();
        this.testedWorkspace.cleanBuild();
        Assert.assertEquals((String)("Resources in index:\n" + BuilderUtil.getAllResourceDescriptionsAsString() + "\n"), (long)0L, (long)BuilderUtil.countResourcesInIndex());
        Object[] projects = IResourcesSetupUtil.root().getProjects();
        Assert.assertTrue((String)("Expected empty workspace. Projects were in workspace: " + Arrays.toString(projects)), (projects.length == 0 ? 1 : 0) != 0);
        this.queuedBuildData.reset();
    }

    public void waitForAutoBuild() {
        this.waitForAutoBuild(true);
    }

    public void waitForAutoBuild(boolean assertValidityOfXtextIndex) {
        this.testedWorkspace.build();
        ProjectTestsUtils.waitForAllJobs();
        if (assertValidityOfXtextIndex) {
            this.assertXtextIndexIsValid();
        }
    }

    public void waitForIncrementalBuild() {
        this.waitForIncrementalBuild(true);
    }

    public void waitForIncrementalBuild(boolean assertValidityOfXtextIndex) {
        this.testedWorkspace.build();
        if (assertValidityOfXtextIndex) {
            this.assertXtextIndexIsValid();
        }
    }

    protected void waitForNotReallyBuildButHousekeepingJobs() {
        this.testedWorkspace.joinJobsBeforeBuild();
    }

    public void cleanBuild() throws CoreException {
        IResourcesSetupUtil.cleanBuild();
    }

    protected void syncExtAndBuild() {
        this.libraryManager.registerAllExternalProjects((IProgressMonitor)new NullProgressMonitor());
        this.waitForAutoBuild();
    }

    private void closeAllEditorsForTearDown() {
        IWorkbenchPage page = EclipseUIUtils.getActivePage();
        if (page != null) {
            page.closeAllEditors(false);
        }
    }

    public <T> T getInstance(Class<T> type) {
        Injector injector = N4JSActivator.getInstance().getInjector("org.eclipse.n4js.N4JS");
        return (T)injector.getInstance(type);
    }

    protected IResourceDescriptions getXtextIndex() {
        ResourceSet resourceSet = this.getResourceSet(null);
        resourceSet.getLoadOptions().put("org.eclipse.xtext.builder.impl.PersistentDataAwareDirtyResource.PERSISTED_DESCRIPTIONS", Boolean.TRUE);
        return this.resourceDescriptionsProvider.getResourceDescriptions(resourceSet);
    }

    protected ResourceSet getResourceSet(IProject project) {
        return this.resourceSetProvider.get(project);
    }

    protected void assertCorrectOutput(IFile module, CharSequence expectedOutput) throws ExecutionException {
        URI moduleURI = URI.createPlatformResourceURI((String)module.getFullPath().toString(), (boolean)true);
        ProcessResult result = this.projectTestsHelper.runWithNodeRunnerUI(moduleURI);
        String actualOutput = result.getStdOut().trim();
        String expectedOutputTrimmed = expectedOutput.toString().trim();
        Assert.assertEquals((String)("incorrect output when running " + module.getName()), (Object)expectedOutputTrimmed, (Object)actualOutput);
    }

    protected void assertXtextIndexIsValid() {
        IWorkspaceRoot rule = ResourcesPlugin.getWorkspace().getRoot();
        try {
            Job.getJobManager().beginRule((ISchedulingRule)rule, null);
            this.assertXtextIndexIsValidInternal();
        }
        finally {
            Job.getJobManager().endRule((ISchedulingRule)rule);
        }
    }

    private void assertXtextIndexIsValidInternal() {
        IResourceDescriptions index = this.getXtextIndex();
        StringBuilder sb = new StringBuilder();
        for (IResourceDescription desc : index.getAllResourceDescriptions()) {
            if (!(desc instanceof ResourceDescriptionWithoutModuleUserData)) continue;
            sb.append("\n");
            sb.append(IResourceDescription.class.getSimpleName());
            sb.append(" in index must not be an instance of ");
            sb.append(ResourceDescriptionWithoutModuleUserData.class.getSimpleName());
            sb.append(" but it was. URI: ");
            sb.append(desc.getURI());
        }
        Assert.assertTrue((String)sb.toString(), (sb.length() == 0 ? 1 : 0) != 0);
    }
}

