/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc2spec.adoc;

import java.io.File;
import java.util.Map;
import java.util.SortedSet;
import org.eclipse.n4js.jsdoc2spec.SpecInfo;
import org.eclipse.n4js.jsdoc2spec.SpecTestInfo;
import org.eclipse.n4js.jsdoc2spec.adoc.ADocFactory;
import org.eclipse.n4js.jsdoc2spec.adoc.StringCountUtils;
import org.eclipse.n4js.ts.types.TMember;

public abstract class SpecSection
implements Comparable<SpecSection> {
    final SpecInfo specInfo;
    final File rootDir;
    private String adocText;
    private int changeLineCount;
    private final SortedSet<SpecTestInfo> testsForType;
    private final Map<TMember, SortedSet<SpecTestInfo>> testsForInheritedMembers;
    private SortedSet<SpecTestInfo> testsForMember;

    public abstract String getSpecModuleKey();

    public abstract String getSpecKey();

    public abstract File getFile();

    protected abstract String computeADocText(ADocFactory var1, Map<String, SpecSection> var2);

    SpecSection(SpecInfo specInfo, File rootDir) {
        this.specInfo = specInfo;
        this.rootDir = rootDir;
        if (specInfo != null) {
            this.testsForType = specInfo.getTestsForType();
            this.testsForInheritedMembers = specInfo.getTestsForInheritedMembers();
        } else {
            this.testsForType = null;
            this.testsForInheritedMembers = null;
        }
    }

    public SpecInfo getSpecInfo() {
        return this.specInfo;
    }

    public String generateADocText(ADocFactory adocFactory, Map<String, SpecSection> specsByKey) {
        if (this.adocText == null) {
            this.adocText = String.valueOf(this.computeADocText(adocFactory, specsByKey)) + "\n";
            this.changeLineCount = StringCountUtils.countNewLines(this.adocText);
        }
        return this.adocText;
    }

    public String getGeneratedADocText() {
        return this.adocText;
    }

    public int getGeneratedLineCount() {
        return this.changeLineCount;
    }

    public void setADocText(String adocText) {
        this.adocText = adocText;
    }

    public SortedSet<SpecTestInfo> getTestInfosForType() {
        return this.testsForType;
    }

    public Map<TMember, SortedSet<SpecTestInfo>> getTestInfosForInheritedMember() {
        return this.testsForInheritedMembers;
    }

    public void setTestInfosForMember(SortedSet<SpecTestInfo> testsForMember) {
        this.testsForMember = testsForMember;
    }

    public SortedSet<SpecTestInfo> getTestInfosForMember() {
        return this.testsForMember;
    }

    public int hashCode() {
        return this.getSpecKey().hashCode();
    }

    @Override
    public int compareTo(SpecSection o) {
        return this.getSpecKey().compareTo(o.getSpecKey());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SpecSection)) {
            return false;
        }
        return this.getSpecKey().equals(((SpecSection)obj).getSpecKey());
    }

    public String toString() {
        return this.getSpecKey();
    }
}

