/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Appender;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.varia.NullAppender;
import org.eclipse.n4js.cli.N4jscBackend;
import org.eclipse.n4js.cli.N4jscConsole;
import org.eclipse.n4js.cli.N4jscException;
import org.eclipse.n4js.cli.N4jscExitCode;
import org.eclipse.n4js.cli.N4jscFactory;
import org.eclipse.n4js.cli.N4jscOptions;
import org.eclipse.n4js.cli.N4jscOptionsValidater;
import org.eclipse.n4js.cli.compiler.N4jscCompiler;
import org.eclipse.n4js.smith.CollectedDataAccess;
import org.eclipse.n4js.smith.DataCollectorCSVExporter;
import org.eclipse.n4js.smith.Measurement;
import org.eclipse.n4js.smith.N4JSDataCollectors;
import org.eclipse.n4js.utils.N4JSLanguageUtils;

public class N4jscMain {
    private static final Logger LOG = LogManager.getLogger(N4jscCompiler.class);

    public static void main(String[] args) {
        N4jscOptions options = N4jscMain.getOptions(args);
        if (options.isDefinedPerformanceOption()) {
            N4jscConsole.println("Performance Data Collection is enabled.");
            CollectedDataAccess.setPaused((boolean)false);
        }
        if (options.isShowSetup()) {
            N4jscConsole.println(options.toSettingsString());
        }
        if (!options.isVerbose()) {
            Logger.getRootLogger().removeAllAppenders();
            Logger.getRootLogger().addAppender((Appender)new NullAppender());
        }
        try {
            try {
                Throwable throwable = null;
                Object var3_7 = null;
                try (Measurement m = N4JSDataCollectors.dcCli.getMeasurement("n4jsc goal");){
                    N4jscMain.performGoal(options);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (N4jscException e) {
                throw e;
            }
            catch (Exception e) {
                throw new N4jscException(N4jscExitCode.ERROR_UNEXPECTED, (Throwable)e);
            }
            N4jscMain.writePerformanceReportIfRequested(options);
            System.exit(N4jscExitCode.SUCCESS.getExitCodeValue());
        }
        catch (N4jscException e) {
            N4jscConsole.println(e.toUserString());
            if (options.isVerbose()) {
                e.printStackTrace();
            }
            System.exit(e.getExitCode());
        }
    }

    private static N4jscOptions getOptions(String[] args) {
        N4jscOptions options = new N4jscOptions();
        try {
            try {
                options.read(args);
            }
            finally {
                if (options.isVerbose()) {
                    LOG.info((Object)("Called with: " + options.toCallString()));
                }
            }
            N4jscOptionsValidater.validate(options);
            return options;
        }
        catch (N4jscException e) {
            N4jscConsole.println(e.toUserString());
            N4jscConsole.println("Usage: n4jsc [GOAL] DIR [OPTION(s)]");
            System.exit(e.getExitCode());
            return null;
        }
    }

    private static void performGoal(N4jscOptions options) throws Exception {
        N4jscBackend backend = N4jscFactory.createBackend();
        switch (options.getGoal()) {
            case help: {
                options.printUsage(N4jscConsole.getPrintStream());
                return;
            }
            case version: {
                N4jscConsole.println(N4JSLanguageUtils.getLanguageVersion());
                return;
            }
            case lsp: {
                backend.goalLsp(options);
                return;
            }
            case clean: {
                backend.goalClean(options);
                return;
            }
            case compile: {
                backend.goalCompile(options);
                return;
            }
            case api: {
                backend.goalApi(options);
                return;
            }
            case watch: {
                backend.goalWatch(options);
                return;
            }
        }
    }

    private static void writePerformanceReportIfRequested(N4jscOptions options) throws N4jscException {
        if (options.isDefinedPerformanceOption()) {
            String performanceKey = options.getPerformanceKey();
            File performanceReportFile = options.getPerformanceReport();
            String absFileString = performanceReportFile.toPath().toAbsolutePath().toString();
            String verb = performanceReportFile.exists() ? "Replacing " : "Writing ";
            N4jscConsole.println(String.valueOf(verb) + "performance report: " + absFileString);
            try {
                DataCollectorCSVExporter.toFile((File)performanceReportFile, (String)performanceKey);
            }
            catch (IOException e) {
                throw new N4jscException(N4jscExitCode.PERFORMANCE_REPORT_ERROR);
            }
        }
    }
}

