/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server.build;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.ide.xtext.server.build.XBuildContext;
import org.eclipse.n4js.ide.xtext.server.build.XBuildRequest;
import org.eclipse.n4js.ide.xtext.server.build.XBuildResult;
import org.eclipse.n4js.ide.xtext.server.build.XIndexState;
import org.eclipse.n4js.ide.xtext.server.build.XSource2GeneratedMapping;
import org.eclipse.n4js.ide.xtext.server.build.XStatefulIncrementalBuilder;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.clustering.DisabledClusteringPolicy;
import org.eclipse.xtext.resource.clustering.IResourceClusteringPolicy;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.xbase.lib.Functions;

public class XIncrementalBuilder {
    @Inject
    protected IResourceServiceProvider.Registry languagesRegistry;
    @Inject
    private Provider<XStatefulIncrementalBuilder> provider;
    @Inject
    private OperationCanceledManager operationCanceledManager;

    public XBuildResult build(XBuildRequest request) {
        return this.build(request, (IResourceClusteringPolicy)new DisabledClusteringPolicy());
    }

    public XBuildResult build(XBuildRequest request, IResourceClusteringPolicy clusteringPolicy) {
        ResourceDescriptionsData resDescrsCopy = request.getState().getResourceDescriptions().copy();
        XSource2GeneratedMapping fileMappingsCopy = request.getState().getFileMappings().copy();
        XIndexState oldState = new XIndexState(resDescrsCopy, fileMappingsCopy);
        XtextResourceSet resourceSet = request.getResourceSet();
        XBuildContext context = new XBuildContext((Functions.Function1<? super URI, ? extends IResourceServiceProvider>)((Functions.Function1)arg_0 -> ((IResourceServiceProvider.Registry)this.languagesRegistry).getResourceServiceProvider(arg_0)), resourceSet, oldState, clusteringPolicy, request.getCancelIndicator());
        XStatefulIncrementalBuilder builder = (XStatefulIncrementalBuilder)this.provider.get();
        builder.setContext(context);
        builder.setRequest(request);
        try {
            return builder.launch();
        }
        catch (Throwable t) {
            this.operationCanceledManager.propagateIfCancelException(t);
            throw t;
        }
    }
}

