/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;

public class TargetWeaver {
    private static boolean fgIsDev = false;
    private static String fgDevPropertiesURL = null;
    private static Properties fgDevProperties = null;

    static {
        fgIsDev = Platform.inDevelopmentMode();
        if (fgIsDev) {
            fgDevPropertiesURL = System.getProperty("osgi.dev");
        }
    }

    protected static Properties getDevProperties() {
        if (fgIsDev) {
            block16: {
                if (fgDevProperties == null) {
                    fgDevProperties = new Properties();
                    if (fgDevPropertiesURL != null) {
                        try {
                            File file;
                            URL url = new URL(fgDevPropertiesURL);
                            String path = url.getFile();
                            if (path == null || path.length() <= 0 || !(file = new File(path)).exists()) break block16;
                            try {
                                Throwable throwable = null;
                                Object var4_7 = null;
                                try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
                                    fgDevProperties.load(stream);
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                            }
                            catch (IOException e) {
                                PDECore.log(e);
                            }
                        }
                        catch (MalformedURLException e) {
                            PDECore.log(e);
                        }
                    }
                }
            }
            return fgDevProperties;
        }
        return null;
    }

    public static void weaveManifest(Map<String, String> manifest) {
        if (manifest != null && fgIsDev) {
            Properties properties = TargetWeaver.getDevProperties();
            String id = manifest.get("Bundle-SymbolicName");
            if (id != null) {
                String property;
                int index = id.indexOf(59);
                if (index != -1) {
                    id = id.substring(0, index);
                }
                if ((property = properties.getProperty(id, null)) != null) {
                    manifest.put("Bundle-ClassPath", property);
                }
            }
        }
    }

    public static void weaveDevProperties(Properties properties) {
        Properties devProperties;
        if (fgIsDev && (devProperties = TargetWeaver.getDevProperties()) != null) {
            Set<Map.Entry<Object, Object>> entries = devProperties.entrySet();
            for (Map.Entry<Object, Object> entry : entries) {
                properties.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public static String getWeavedSourceLibraryName(IPluginModelBase model, String libraryName) {
        if (fgIsDev && !new File(libraryName).isAbsolute()) {
            String property;
            Properties properties = TargetWeaver.getDevProperties();
            String id = null;
            if (model.getBundleDescription() != null) {
                id = model.getBundleDescription().getSymbolicName();
            }
            if (id != null && !new File(model.getInstallLocation()).isFile() && model.getUnderlyingResource() == null && (property = properties.getProperty(id, null)) != null) {
                return "";
            }
        }
        return libraryName;
    }
}

