/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils.io;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.OutputStream;
import org.eclipse.n4js.utils.io.OutputRedirection;
import org.eclipse.n4js.utils.io.OutputStreamPrinterThread;
import org.eclipse.n4js.utils.io.OutputStreamProvider;

@Singleton
public class OutputStreamPrinterThreadProvider {
    @Inject
    private OutputStreamProvider osProvider;

    public OutputStreamPrinterThread getPrinterThreadForStdOut(Process process, OutputRedirection redirect) {
        OutputStream os = this.osProvider.getOutputStream(OutputStreamPrinterThread.OutputStreamType.STD_OUT, redirect);
        OutputStreamPrinterThread thread = new OutputStreamPrinterThread(process.getInputStream(), os, redirect);
        thread.start();
        return thread;
    }

    public OutputStreamPrinterThread getPrinterThreadForStdErr(Process process, OutputRedirection redirect) {
        OutputStream os = this.osProvider.getOutputStream(OutputStreamPrinterThread.OutputStreamType.STD_ERR, redirect);
        OutputStreamPrinterThread thread = new OutputStreamPrinterThread(process.getErrorStream(), os, redirect);
        thread.start();
        return thread;
    }
}

