/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.formatting2;

import java.util.List;
import org.eclipse.xtext.formatting2.ITextReplacerContext;
import org.eclipse.xtext.formatting2.internal.MultilineCommentReplacer;
import org.eclipse.xtext.formatting2.regionaccess.IComment;
import org.eclipse.xtext.formatting2.regionaccess.ILineRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;

public class N4MultilineCommentReplacer
extends MultilineCommentReplacer {
    private final boolean multiline;
    private final char prefix;

    public N4MultilineCommentReplacer(IComment comment, char prefix) {
        super(comment, prefix);
        this.prefix = prefix;
        this.multiline = comment.isMultiline();
    }

    public ITextReplacerContext createReplacements(ITextReplacerContext context) {
        if (!this.multiline) {
            return context;
        }
        IComment comment = this.getComment();
        ITextRegionAccess access = comment.getTextRegionAccess();
        List lines = comment.getLineRegions();
        String oldIndentation = ((ILineRegion)lines.get(0)).getIndentation().getText();
        String indentationString = context.getIndentationString();
        String newIndentation = String.valueOf(indentationString) + " " + this.prefix;
        String newIndentation2 = String.valueOf(newIndentation) + " ";
        int i = 1;
        while (i < lines.size() - 1) {
            ITextSegment line = (ITextSegment)lines.get(i);
            String text = line.getText();
            int prefixOffset = this.prefixOffset(text);
            ITextSegment target = prefixOffset >= 0 ? access.regionForOffset(line.getOffset(), prefixOffset + 1) : (text.startsWith(oldIndentation) ? access.regionForOffset(line.getOffset(), oldIndentation.length() + this.nonWhiteSpaceOffset(text.substring(oldIndentation.length()))) : access.regionForOffset(line.getOffset(), this.nonWhiteSpaceOffset(text)));
            if (line.getEndOffset() - target.getEndOffset() > 0) {
                context.addReplacement(target.replaceWith(newIndentation2));
            } else {
                context.addReplacement(target.replaceWith(newIndentation));
            }
            ++i;
        }
        if (lines.size() > 1) {
            ILineRegion line = (ILineRegion)lines.get(lines.size() - 1);
            context.addReplacement(line.getIndentation().replaceWith(String.valueOf(indentationString) + " "));
        }
        return context;
    }

    protected int nonWhiteSpaceOffset(String string) {
        int i = 0;
        while (i < string.length()) {
            char charAt = string.charAt(i);
            if (!Character.isWhitespace(charAt)) {
                return i;
            }
            ++i;
        }
        return string.length();
    }
}

