/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.TreeMultimap;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.ide.xtext.server.HashedFileContent;
import org.eclipse.n4js.ide.xtext.server.ProjectStatePersister;
import org.eclipse.n4js.ide.xtext.server.ProjectStatePersisterConfig;
import org.eclipse.n4js.ide.xtext.server.ResourceChangeSet;
import org.eclipse.n4js.ide.xtext.server.build.XBuildRequest;
import org.eclipse.n4js.ide.xtext.server.build.XBuildResult;
import org.eclipse.n4js.ide.xtext.server.build.XIndexState;
import org.eclipse.n4js.ide.xtext.server.build.XSource2GeneratedMapping;
import org.eclipse.n4js.utils.URIUtils;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.util.IFileSystemScanner;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.ISourceFolder;

public class ProjectStateHolder {
    @Inject
    protected ProjectStatePersister projectStatePersister;
    @Inject
    protected IFileSystemScanner fileSystemScanner;
    @Inject
    protected ProjectStatePersisterConfig persistConfig;
    @Inject
    protected IResourceServiceProvider.Registry resourceServiceProviders;
    private XIndexState indexState = new XIndexState();
    private Map<URI, HashedFileContent> uriToHashedFileContents = new HashMap<URI, HashedFileContent>();
    private final Multimap<URI, Issue> validationIssues = TreeMultimap.create(Comparator.comparing(Object::toString), issueComparator);
    private static final Comparator<Issue> issueComparator = Comparator.comparing(ProjectStateHolder::getOffset).thenComparing(ProjectStateHolder::getSeverity).thenComparing(ProjectStateHolder::getMessage).thenComparing(Object::hashCode);

    private static int getOffset(Issue issue) {
        Integer result = issue.getOffset();
        if (result == null) {
            return -1;
        }
        return result;
    }

    private static Severity getSeverity(Issue issue) {
        Severity result = issue.getSeverity();
        if (result == null) {
            return Severity.ERROR;
        }
        return result;
    }

    private static String getMessage(Issue issue) {
        String result = issue.getMessage();
        return Strings.emptyIfNull((String)result);
    }

    public void doClear() {
        this.uriToHashedFileContents.clear();
        this.setIndexState(new XIndexState());
        this.validationIssues.clear();
    }

    public void deletePersistenceFile(IProjectConfig projectConfig) {
        URI persistenceFileURI = this.getPersistenceFile(projectConfig);
        File persistenceFile = URIUtils.toFile((URI)persistenceFileURI);
        if (persistenceFile.isFile()) {
            persistenceFile.delete();
        }
    }

    public void writeProjectState(IProjectConfig projectConfig) {
        if (this.persistConfig.isWriteToDisk(projectConfig) && !this.uriToHashedFileContents.isEmpty()) {
            Collection<HashedFileContent> hashFileContents = this.uriToHashedFileContents.values();
            this.projectStatePersister.writeProjectState(projectConfig, this.indexState, hashFileContents, this.getValidationIssues());
        }
    }

    public Map<URI, Collection<Issue>> getValidationIssues() {
        return Multimaps.unmodifiableMultimap(this.validationIssues).asMap();
    }

    public ResourceChangeSet readProjectState(IProjectConfig projectConfig) {
        if (this.persistConfig.isDeleteState(projectConfig)) {
            this.deletePersistenceFile(projectConfig);
        }
        ResourceChangeSet result = new ResourceChangeSet();
        this.doClear();
        ProjectStatePersister.PersistedState persistedState = this.projectStatePersister.readProjectState(projectConfig);
        if (persistedState != null) {
            for (HashedFileContent hfc : persistedState.fileHashs.values()) {
                URI previouslyExistingFile = hfc.getUri();
                switch (this.getSourceChangeKind(hfc, persistedState)) {
                    case UNCHANGED: {
                        this.uriToHashedFileContents.put(previouslyExistingFile, hfc);
                        break;
                    }
                    case CHANGED: {
                        result.getModified().add(previouslyExistingFile);
                        persistedState.validationIssues.remove(previouslyExistingFile);
                        break;
                    }
                    case DELETED: {
                        result.getDeleted().add(previouslyExistingFile);
                        persistedState.validationIssues.remove(previouslyExistingFile);
                    }
                }
            }
            this.setIndexState(persistedState.indexState);
            this.mergeValidationIssues(persistedState.validationIssues);
        }
        Set allIndexedUris = this.indexState.getResourceDescriptions().getAllURIs();
        for (ISourceFolder srcFolder : projectConfig.getSourceFolders()) {
            List allSourceFolderUris = srcFolder.getAllResources(this.fileSystemScanner);
            for (URI srcFolderUri : allSourceFolderUris) {
                if (srcFolderUri.hasTrailingPathSeparator() || allIndexedUris.contains(srcFolderUri) || this.resourceServiceProviders.getResourceServiceProvider(srcFolderUri) == null) continue;
                result.getModified().add(srcFolderUri);
            }
        }
        return result;
    }

    public void updateProjectState(XBuildRequest request, XBuildResult result) {
        HashMap<URI, HashedFileContent> newFileContents = new HashMap<URI, HashedFileContent>(this.uriToHashedFileContents);
        for (IResourceDescription.Delta delta : result.getAffectedResources()) {
            URI uri = delta.getUri();
            this.storeHash(newFileContents, uri);
        }
        for (URI deletedFile : request.getResultDeleteFiles()) {
            newFileContents.remove(deletedFile);
        }
        this.setIndexState(result.getIndexState());
        this.mergeValidationIssues(request.getResultIssues());
        this.uriToHashedFileContents = newFileContents;
    }

    private SourceChangeKind getSourceChangeKind(HashedFileContent hfc, ProjectStatePersister.PersistedState persistedState) {
        URI sourceUri = hfc.getUri();
        long loadedHash = hfc.getHash();
        HashedFileContent newHash = this.doHash(sourceUri);
        if (newHash == null) {
            return SourceChangeKind.DELETED;
        }
        if (loadedHash != newHash.getHash()) {
            return SourceChangeKind.CHANGED;
        }
        XSource2GeneratedMapping sourceFileMappings = persistedState.indexState.getFileMappings();
        List<URI> allPrevGenerated = sourceFileMappings.getGenerated(sourceUri);
        for (URI prevGenerated : allPrevGenerated) {
            File prevGeneratedFile = new File(prevGenerated.path());
            if (prevGeneratedFile.isFile()) continue;
            return SourceChangeKind.CHANGED;
        }
        return SourceChangeKind.UNCHANGED;
    }

    private HashedFileContent doHash(URI uri) {
        File srcFile;
        block3: {
            try {
                srcFile = new File(uri.path());
                if (srcFile.isFile()) break block3;
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        HashedFileContent generatedTargetContent = new HashedFileContent(uri, srcFile);
        return generatedTargetContent;
    }

    private void storeHash(HashMap<URI, HashedFileContent> newFileContents, URI uri) {
        HashedFileContent generatedTargetContent = this.doHash(uri);
        if (generatedTargetContent != null) {
            newFileContents.put(uri, generatedTargetContent);
        }
    }

    public URI getPersistenceFile(IProjectConfig projectConfig) {
        URI persistanceFile = this.projectStatePersister.getFileName(projectConfig);
        return persistanceFile;
    }

    public XIndexState getIndexState() {
        return this.indexState;
    }

    protected void setIndexState(XIndexState indexState) {
        this.indexState = indexState;
    }

    protected void mergeValidationIssues(Map<URI, Collection<Issue>> issueMap) {
        for (Map.Entry<URI, Collection<Issue>> entry : issueMap.entrySet()) {
            URI source = entry.getKey();
            this.validationIssues.replaceValues((Object)source, (Iterable)entry.getValue());
        }
    }

    static enum SourceChangeKind {
        UNCHANGED,
        CHANGED,
        DELETED;

    }
}

