/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.quickfix.packagejson;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.function.Function;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.n4js.external.ExternalIndexSynchronizer;
import org.eclipse.n4js.external.LibraryManager;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.projectModel.locations.PlatformResourceURI;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.semver.Semver.NPMVersionRequirement;
import org.eclipse.n4js.semver.SemverHelper;
import org.eclipse.n4js.ui.changes.IAtomicChange;
import org.eclipse.n4js.ui.changes.IChange;
import org.eclipse.n4js.ui.changes.PackageJsonChangeProvider;
import org.eclipse.n4js.ui.internal.N4JSActivator;
import org.eclipse.n4js.ui.quickfix.AbstractN4JSQuickfixProvider;
import org.eclipse.n4js.ui.quickfix.N4Modification;
import org.eclipse.n4js.ui.utils.UIUtils;
import org.eclipse.n4js.utils.StatusHelper;
import org.eclipse.n4js.utils.StatusUtils;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.Fixes;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;

public class N4JSPackageJsonQuickfixProviderExtension
extends AbstractN4JSQuickfixProvider {
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private LibraryManager libraryManager;
    @Inject
    private ExternalIndexSynchronizer indexSynchronizer;
    @Inject
    private SemverHelper semverHelper;
    @Inject
    private StatusHelper statusHelper;

    @Fixes(value={@Fix(value="NON_EXISTING_PROJECT"), @Fix(value="NO_MATCHING_VERSION"), @Fix(value="MISSING_YARN_WORKSPACE")})
    public void installMissingNPM(final Issue issue, IssueResolutionAcceptor acceptor) {
        String[] userData = issue.getData();
        final String packageName = userData[0];
        final String versionRequirement = userData[1];
        String msgAtVersion = Strings.isNullOrEmpty((String)versionRequirement) ? "" : "@" + versionRequirement;
        final String label = "Install npm package " + packageName + msgAtVersion;
        String description = "Calls npm/yarn to install the missing npm package into the workspace.";
        final String errMsg = "Error while uninstalling npm dependency: '" + packageName + "'.";
        N4Modification modification = new N4Modification(){

            @Override
            public Collection<? extends IChange> computeChanges(IModificationContext context, IMarker marker, int offset, int length, EObject element) throws Exception {
                Function<IProgressMonitor, IStatus> registerFunction = new Function<IProgressMonitor, IStatus>(){

                    @Override
                    public IStatus apply(IProgressMonitor monitor) {
                        URI uri = issue.getUriToProblem();
                        IN4JSProject containingProject = (IN4JSProject)(this).N4JSPackageJsonQuickfixProviderExtension.this.n4jsCore.findProject(uri).orNull();
                        if (containingProject == null) {
                            return (this).N4JSPackageJsonQuickfixProviderExtension.this.statusHelper.createError("cannot find containing project");
                        }
                        FileURI targetLocation = containingProject.getLocation().toFileURI();
                        HashMap<N4JSProjectName, NPMVersionRequirement> installedNpms = new HashMap<N4JSProjectName, NPMVersionRequirement>();
                        NPMVersionRequirement versionReq = (this).N4JSPackageJsonQuickfixProviderExtension.this.semverHelper.parse(versionRequirement);
                        N4JSProjectName typesafePackageName = new N4JSProjectName(packageName);
                        installedNpms.put(typesafePackageName, versionReq);
                        return (this).N4JSPackageJsonQuickfixProviderExtension.this.libraryManager.installNPM(typesafePackageName, versionRequirement, targetLocation, monitor);
                    }
                };
                N4JSPackageJsonQuickfixProviderExtension.this.wrapWithMonitor(label, errMsg, registerFunction);
                return Collections.emptyList();
            }
        };
        this.accept(acceptor, issue, label, "Calls npm/yarn to install the missing npm package into the workspace.", null, modification);
    }

    @Fixes(value={@Fix(value="NON_EXISTING_PROJECT"), @Fix(value="NO_MATCHING_VERSION"), @Fix(value="MISSING_YARN_WORKSPACE")})
    public void runNpmInstallInProject(final Issue issue, IssueResolutionAcceptor acceptor) {
        String label = "Run 'npm/yarn install' in this project";
        String description = "Runs 'npm/yarn install' on this project and then registers all npms.";
        String errMsg = "Error while installing npms";
        N4Modification modification = new N4Modification(){

            @Override
            public boolean supportsMultiApply() {
                return false;
            }

            @Override
            public Collection<? extends IChange> computeChanges(IModificationContext context, IMarker marker, int offset, int length, EObject element) throws Exception {
                Function<IProgressMonitor, IStatus> registerFunction = new Function<IProgressMonitor, IStatus>(){

                    @Override
                    public IStatus apply(IProgressMonitor monitor) {
                        return (this).N4JSPackageJsonQuickfixProviderExtension.this.libraryManager.runNpmYarnInstall(new PlatformResourceURI(issue.getUriToProblem()), monitor);
                    }
                };
                N4JSPackageJsonQuickfixProviderExtension.this.wrapWithMonitor("Run 'npm/yarn install' in this project", "Error while installing npms", registerFunction);
                return Collections.emptyList();
            }
        };
        this.accept(acceptor, issue, "Run 'npm/yarn install' in this project", "Runs 'npm/yarn install' on this project and then registers all npms.", null, modification);
    }

    @Fixes(value={@Fix(value="NON_EXISTING_PROJECT"), @Fix(value="NO_MATCHING_VERSION")})
    public void runNpmInstallInAllProjects(Issue issue, IssueResolutionAcceptor acceptor) {
        String label = "Run 'npm/yarn install' in all projects";
        String description = "Runs 'npm/yarn install' on all projects sequentially and then registers all npms.";
        String errMsg = "Error while installing npms";
        N4Modification modification = new N4Modification(){

            @Override
            public boolean supportsMultiApply() {
                return false;
            }

            @Override
            public Collection<? extends IChange> computeChanges(IModificationContext context, IMarker marker, int offset, int length, EObject element) throws Exception {
                Function<IProgressMonitor, IStatus> registerFunction = new Function<IProgressMonitor, IStatus>(){

                    @Override
                    public IStatus apply(IProgressMonitor monitor) {
                        return (this).N4JSPackageJsonQuickfixProviderExtension.this.libraryManager.runNpmYarnInstallOnAllProjects(monitor);
                    }
                };
                N4JSPackageJsonQuickfixProviderExtension.this.wrapWithMonitor("Run 'npm/yarn install' in all projects", "Error while installing npms", registerFunction);
                return Collections.emptyList();
            }
        };
        this.accept(acceptor, issue, "Run 'npm/yarn install' in all projects", "Runs 'npm/yarn install' on all projects sequentially and then registers all npms.", null, modification);
    }

    @Fix(value="NON_REGISTERED_PROJECT")
    public void registerNPMs(Issue issue, IssueResolutionAcceptor acceptor) {
        String label = "Register npm(s)";
        String description = "Registers all not registered npms so that they can be imported by modules.";
        N4Modification modification = new N4Modification(){

            @Override
            public Collection<? extends IChange> computeChanges(IModificationContext context, IMarker marker, int offset, int length, EObject element) throws Exception {
                Function<IProgressMonitor, IStatus> registerFunction = new Function<IProgressMonitor, IStatus>(){

                    @Override
                    public IStatus apply(IProgressMonitor monitor) {
                        (this).N4JSPackageJsonQuickfixProviderExtension.this.indexSynchronizer.synchronizeNpms(monitor);
                        return (this).N4JSPackageJsonQuickfixProviderExtension.this.statusHelper.OK();
                    }
                };
                N4JSPackageJsonQuickfixProviderExtension.this.wrapWithMonitor("Register npm(s)", "Error during registering of npm(s)", registerFunction);
                return Collections.emptyList();
            }
        };
        this.accept(acceptor, issue, "Register npm(s)", "Registers all not registered npms so that they can be imported by modules.", null, modification);
    }

    @Fix(value="OUTPUT_AND_SOURCES_FOLDER_NESTING")
    public void changeProjectTypeToValidation(Issue issue, IssueResolutionAcceptor acceptor) {
        String validationPT = ProjectType.VALIDATION.getName().toLowerCase();
        String title = "Change project type to '" + validationPT + "'";
        String descr = "The project type '" + validationPT + "' does not generate code. Hence, output and source folders can be nested.";
        this.accept(acceptor, issue, title, descr, null, new N4Modification(){

            @Override
            public Collection<? extends IChange> computeChanges(IModificationContext context, IMarker marker, int offset, int length, EObject element) throws Exception {
                Resource resource = element.eResource();
                ProjectDescription prjDescr = (ProjectDescription)EcoreUtil2.getContainerOfType((EObject)element, ProjectDescription.class);
                LinkedList<IAtomicChange> changes = new LinkedList<IAtomicChange>();
                changes.add(PackageJsonChangeProvider.setProjectType(resource, ProjectType.VALIDATION, prjDescr));
                return changes;
            }

            @Override
            public boolean supportsMultiApply() {
                return false;
            }
        });
    }

    private Collection<? extends IChange> wrapWithMonitor(final String msg, String errMsg, Function<IProgressMonitor, IStatus> f) throws Exception {
        final MultiStatus multiStatus = this.statusHelper.createMultiStatus(msg);
        new ProgressMonitorDialog(UIUtils.getShell()).run(true, false, monitor -> {
            try {
                IStatus status = (IStatus)f.apply(monitor);
                multiStatus.merge(status);
            }
            catch (Exception e) {
                multiStatus.merge(this.statusHelper.createError(errMsg, (Throwable)e));
            }
        });
        if (!multiStatus.isOK()) {
            N4JSActivator.getInstance().getLog().log((IStatus)multiStatus);
            UIUtils.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    String title = "Failed: " + msg;
                    String descr = StatusUtils.getErrorMessage((IStatus)multiStatus, (boolean)true);
                    ErrorDialog.openError((Shell)UIUtils.getShell(), (String)title, (String)descr, (IStatus)multiStatus);
                }
            });
        }
        return Collections.emptyList();
    }
}

