/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.ui.registry;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.xpect.registry.IExtensionInfo;
import org.osgi.framework.Bundle;

public class UIExtensionInfoRegistry
implements IExtensionInfo.Registry {
    public Collection<String> getExtensionPoints() {
        ArrayList names = Lists.newArrayList();
        IExtensionPoint[] iExtensionPointArray = Platform.getExtensionRegistry().getExtensionPoints();
        int n = iExtensionPointArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtensionPoint ep = iExtensionPointArray[n2];
            names.add(ep.getUniqueIdentifier());
            ++n2;
        }
        return names;
    }

    public Collection<IExtensionInfo> getExtensions(String extensionPointName) {
        ArrayList result = Lists.newArrayList();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionPointName);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement cfg = iConfigurationElementArray[n2];
            result.add(new UiExtensionInfo(cfg));
            ++n2;
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("<plugin>\n");
        for (String point : this.getExtensionPoints()) {
            result.append("  <extension point=\"");
            result.append(point);
            result.append("\">\n");
            for (IExtensionInfo ext : this.getExtensions(point)) {
                result.append("    ");
                result.append(ext.toString());
                result.append("\n");
            }
        }
        result.append("  </extension>\n");
        result.append("</plugin>");
        return result.toString();
    }

    public static class UiExtensionInfo
    implements IExtensionInfo {
        private final IConfigurationElement configurationElement;

        public UiExtensionInfo(IConfigurationElement configurationElement) {
            this.configurationElement = configurationElement;
        }

        public Collection<String> getAttributes() {
            return Lists.newArrayList((Object[])this.configurationElement.getAttributeNames());
        }

        public String getAttributeValue(String name) {
            return this.configurationElement.getAttribute(name);
        }

        public Function<String, Class<?>> getClassLoader() {
            return new Function<String, Class<?>>(){

                public Class<?> apply(String input) {
                    try {
                        String bundleName = configurationElement.getContributor().getName();
                        Bundle bundle = Platform.getBundle((String)bundleName);
                        return bundle.loadClass(input);
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                    catch (InvalidRegistryObjectException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }

        public String getLocation() {
            return this.configurationElement.getContributor().getName();
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("<");
            result.append(this.configurationElement.getName());
            ArrayList attrs = Lists.newArrayList(this.getAttributes());
            Collections.sort(attrs);
            for (String attr : attrs) {
                result.append(" ");
                result.append(attr);
                result.append("=\"");
                result.append(this.getAttributeValue(attr));
                result.append("\"");
            }
            result.append(" />");
            return result.toString();
        }
    }
}

