/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators.flowgraphs;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.flowgraphs.FlowAnalyser;
import org.eclipse.n4js.flowgraphs.analysers.UsedBeforeDeclaredAnalyser;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.n4js.validation.validators.N4JSFlowgraphValidator;
import org.eclipse.n4js.validation.validators.flowgraphs.FlowValidator;

public class UsedBeforeDeclaredValidator
implements FlowValidator {
    private final UsedBeforeDeclaredAnalyser ubda;

    public UsedBeforeDeclaredValidator(UsedBeforeDeclaredAnalyser usedBeforeDeclaredAnalyser) {
        this.ubda = usedBeforeDeclaredAnalyser;
    }

    @Override
    public FlowAnalyser getFlowAnalyser() {
        return this.ubda;
    }

    @Override
    public void checkResults(N4JSFlowgraphValidator fVali) {
        this.internalCheckUsedBeforeDeclared(fVali);
    }

    private void internalCheckUsedBeforeDeclared(N4JSFlowgraphValidator fVali) {
        List usedBeforeDeclared = this.ubda.getUsedButNotDeclaredIdentifierRefs();
        for (IdentifierRef idRef : usedBeforeDeclared) {
            String varName = idRef.getId().getName();
            String msg = IssueCodes.getMessageForCFG_USED_BEFORE_DECLARED(varName);
            fVali.addIssue(msg, (EObject)idRef, "CFG_USED_BEFORE_DECLARED");
        }
    }
}

