/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.PluginModelDelta;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.iproduct.IProductModelFactory;
import org.eclipse.pde.internal.core.iproduct.IProductPlugin;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.dialogs.PluginSelectionDialog;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.editor.product.VersionDialog;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.pde.internal.ui.search.dependencies.DependencyCalculator;
import org.eclipse.pde.internal.ui.util.PersistablePluginObject;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.plugin.NewFragmentProjectWizard;
import org.eclipse.pde.internal.ui.wizards.plugin.NewPluginProjectWizard;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PluginSection
extends TableSection
implements IPluginModelListener {
    private TableViewer fPluginTable;
    private Button fIncludeOptionalButton;
    private Action fNewPluginAction;
    private Action fNewFragmentAction;
    public static final QualifiedName OPTIONAL_PROPERTY = new QualifiedName("org.eclipse.pde.ui", "product.includeOptional");

    public PluginSection(PDEFormPage formPage, Composite parent) {
        super(formPage, parent, 128, PluginSection.getButtonLabels());
    }

    private static String[] getButtonLabels() {
        String[] labels = new String[]{PDEUIMessages.Product_PluginSection_add, PDEUIMessages.Product_PluginSection_working, PDEUIMessages.Product_PluginSection_required, PDEUIMessages.PluginSection_remove, PDEUIMessages.Product_PluginSection_removeAll, PDEUIMessages.Product_FeatureSection_properties};
        return labels;
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData sectionData = new GridData(1808);
        sectionData.verticalSpan = 2;
        section.setLayoutData((Object)sectionData);
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 2, 2, toolkit);
        container.setLayoutData((Object)new GridData(1808));
        this.createOptionalDependenciesButton(container);
        EditableTablePart tablePart = this.getTablePart();
        this.fPluginTable = tablePart.getTableViewer();
        this.fPluginTable.setContentProvider((IContentProvider)new ContentProvider());
        this.fPluginTable.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.fPluginTable.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IProductPlugin p1 = (IProductPlugin)e1;
                IProductPlugin p2 = (IProductPlugin)e2;
                return super.compare(viewer, (Object)p1.getId(), (Object)p2.getId());
            }
        });
        GridData data = (GridData)tablePart.getControl().getLayoutData();
        data.minimumWidth = 200;
        this.fPluginTable.setInput((Object)this.getProduct());
        tablePart.setButtonEnabled(0, this.isEditable());
        tablePart.setButtonEnabled(1, this.isEditable());
        tablePart.setButtonEnabled(2, this.isEditable());
        tablePart.setButtonEnabled(5, this.isEditable());
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        section.setText(PDEUIMessages.Product_PluginSection_title);
        section.setDescription(PDEUIMessages.Product_PluginSection_desc);
        this.getModel().addModelChangedListener((IModelChangedListener)this);
        this.createSectionToolbar(section, toolkit);
    }

    private void createSectionToolbar(Section section, FormToolkit toolkit) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        Cursor handCursor = Display.getCurrent().getSystemCursor(21);
        toolbar.setCursor(handCursor);
        this.fNewPluginAction = new NewPluginAction();
        this.fNewFragmentAction = new NewFragmentAction();
        toolBarManager.add((IAction)this.fNewPluginAction);
        toolBarManager.add((IAction)this.fNewFragmentAction);
        toolBarManager.update(true);
        section.setTextClient((Control)toolbar);
    }

    private void createOptionalDependenciesButton(Composite container) {
        if (this.isEditable()) {
            this.fIncludeOptionalButton = new Button(container, 32);
            this.fIncludeOptionalButton.setText(PDEUIMessages.PluginSection_includeOptional);
            IEditorInput input = this.getPage().getEditorInput();
            if (input instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)input).getFile();
                try {
                    this.fIncludeOptionalButton.setSelection("true".equals(file.getPersistentProperty(OPTIONAL_PROPERTY)));
                }
                catch (CoreException coreException) {}
            }
            this.fIncludeOptionalButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                if (input instanceof IFileEditorInput) {
                    IFile file = ((IFileEditorInput)input).getFile();
                    try {
                        file.setPersistentProperty(OPTIONAL_PROPERTY, this.fIncludeOptionalButton.getSelection() ? "true" : null);
                    }
                    catch (CoreException coreException) {}
                }
            }));
        }
    }

    @Override
    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAdd();
                break;
            }
            case 1: {
                this.handleAddWorkingSet();
                break;
            }
            case 2: {
                PluginSection.handleAddRequired(this.getProduct().getPlugins(), this.fIncludeOptionalButton.getSelection());
                break;
            }
            case 3: {
                this.handleDelete();
                break;
            }
            case 4: {
                this.handleRemoveAll();
                break;
            }
            case 5: {
                this.handleProperties();
            }
        }
    }

    private void handleNewFragment() {
        NewFragmentProjectWizard wizard = new NewFragmentProjectWizard();
        wizard.init(PDEPlugin.getActiveWorkbenchWindow().getWorkbench(), null);
        WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
        dialog.create();
        SWTUtil.setDialogSize((Dialog)dialog, 400, 500);
        if (dialog.open() == 0) {
            this.addPlugin(wizard.getFragmentId(), wizard.getFragmentVersion());
        }
    }

    private void handleNewPlugin() {
        NewPluginProjectWizard wizard = new NewPluginProjectWizard();
        wizard.init(PDEPlugin.getActiveWorkbenchWindow().getWorkbench(), null);
        WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
        dialog.create();
        SWTUtil.setDialogSize((Dialog)dialog, 400, 500);
        if (dialog.open() == 0) {
            this.addPlugin(wizard.getPluginId(), wizard.getPluginVersion());
        }
    }

    private void handleProperties() {
        IStructuredSelection ssel = this.fPluginTable.getStructuredSelection();
        if (ssel.size() == 1) {
            IProductPlugin plugin = (IProductPlugin)ssel.toArray()[0];
            VersionDialog dialog = new VersionDialog(PDEPlugin.getActiveWorkbenchShell(), this.isEditable(), plugin.getVersion());
            dialog.create();
            SWTUtil.setDialogSize((Dialog)dialog, 400, 200);
            if (dialog.open() == 0) {
                plugin.setVersion(dialog.getVersion());
            }
        }
    }

    @Override
    protected void handleDoubleClick(IStructuredSelection selection) {
        this.handleOpen(selection);
    }

    public void dispose() {
        IProductModel model = this.getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    @Override
    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleDelete();
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleDelete();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return super.doGlobalAction(actionId);
    }

    @Override
    protected boolean canPaste(Object target, Object[] objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof IProductPlugin) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        IStructuredSelection ssel = this.fPluginTable.getStructuredSelection();
        if (ssel == null) {
            return;
        }
        Action openAction = new Action(PDEUIMessages.PluginSection_open){

            public void run() {
                PluginSection.this.handleDoubleClick(PluginSection.this.fPluginTable.getStructuredSelection());
            }
        };
        openAction.setEnabled(this.isEditable() && ssel.size() == 1);
        manager.add((IAction)openAction);
        manager.add((IContributionItem)new Separator());
        Action removeAction = new Action(PDEUIMessages.PluginSection_remove){

            public void run() {
                PluginSection.this.handleDelete();
            }
        };
        removeAction.setEnabled(this.isEditable() && !ssel.isEmpty());
        manager.add((IAction)removeAction);
        Action removeAll = new Action(PDEUIMessages.PluginSection_removeAll){

            public void run() {
                PluginSection.this.handleRemoveAll();
            }
        };
        removeAll.setEnabled(this.isEditable());
        manager.add((IAction)removeAll);
        manager.add((IContributionItem)new Separator());
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
    }

    private void handleOpen(IStructuredSelection selection) {
        Object object = selection.getFirstElement();
        if (object instanceof IProductPlugin) {
            ManifestEditor.openPluginEditor(((IProductPlugin)object).getId());
        }
    }

    public static void handleAddRequired(IProductPlugin[] plugins, boolean includeOptional) {
        BundleDescription[] bundles;
        if (plugins.length == 0) {
            return;
        }
        ArrayList<BundleDescription> list = new ArrayList<BundleDescription>(plugins.length);
        IProductPlugin[] iProductPluginArray = plugins;
        int n = plugins.length;
        int n2 = 0;
        while (n2 < n) {
            IProductPlugin plugin = iProductPluginArray[n2];
            list.add(TargetPlatformHelper.getState().getBundle(plugin.getId(), null));
            ++n2;
        }
        DependencyCalculator calculator = new DependencyCalculator(includeOptional);
        calculator.findDependencies(list.toArray());
        BundleDescription[] bundleDescriptionArray = bundles = TargetPlatformHelper.getState().getBundles();
        int n3 = bundles.length;
        int n4 = 0;
        while (n4 < n3) {
            BundleDescription bundle = bundleDescriptionArray[n4];
            HostSpecification host = bundle.getHost();
            if (host != null && calculator.containsPluginId(host.getName())) {
                calculator.findDependency(bundle);
            }
            ++n4;
        }
        Set<String> dependencies = calculator.getBundleIDs();
        IProduct product = plugins[0].getProduct();
        IProductModelFactory factory = product.getModel().getFactory();
        IProductPlugin[] requiredPlugins = new IProductPlugin[dependencies.size()];
        int i = 0;
        Iterator iter = dependencies.iterator();
        while (iter.hasNext()) {
            String id = iter.next().toString();
            IProductPlugin plugin = factory.createPlugin();
            plugin.setId(id);
            requiredPlugins[i++] = plugin;
        }
        product.addPlugins(requiredPlugins);
    }

    private void handleAddWorkingSet() {
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSetSelectionDialog dialog = manager.createWorkingSetSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), true);
        if (dialog.open() == 0) {
            IWorkingSet[] workingSets = dialog.getSelection();
            IProduct product = this.getProduct();
            IProductModelFactory factory = product.getModel().getFactory();
            ArrayList<IProductPlugin> pluginList = new ArrayList<IProductPlugin>();
            IWorkingSet[] iWorkingSetArray = workingSets;
            int n = workingSets.length;
            int n2 = 0;
            while (n2 < n) {
                IAdaptable[] elements;
                IWorkingSet workingSet = iWorkingSetArray[n2];
                IAdaptable[] iAdaptableArray = elements = workingSet.getElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IAdaptable element = iAdaptableArray[n4];
                    IPluginModelBase model = this.findModel(element);
                    if (model != null) {
                        IProductPlugin plugin = factory.createPlugin();
                        IPluginBase base = model.getPluginBase();
                        plugin.setId(base.getId());
                        pluginList.add(plugin);
                    }
                    ++n4;
                }
                ++n2;
            }
            product.addPlugins(pluginList.toArray(new IProductPlugin[pluginList.size()]));
        }
    }

    private void handleRemoveAll() {
        IProduct product = this.getProduct();
        product.removePlugins(product.getPlugins());
    }

    private void handleDelete() {
        IStructuredSelection ssel = this.fPluginTable.getStructuredSelection();
        if (!ssel.isEmpty()) {
            Object[] objects = ssel.toArray();
            IProductPlugin[] plugins = new IProductPlugin[objects.length];
            System.arraycopy(objects, 0, plugins, 0, objects.length);
            this.getProduct().removePlugins(plugins);
            this.updateRemoveButtons(true, true);
        }
    }

    private void handleAdd() {
        PluginSelectionDialog pluginSelectionDialog = new PluginSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), this.getBundles(), true);
        if (pluginSelectionDialog.open() == 0) {
            Object[] result;
            Object[] objectArray = result = pluginSelectionDialog.getResult();
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                IPluginModelBase pluginModelBase = (IPluginModelBase)object;
                this.addPlugin(pluginModelBase.getPluginBase().getId(), "0.0.0");
                ++n2;
            }
        }
    }

    private IPluginModelBase[] getBundles() {
        BundleDescription[] bundles;
        ArrayList<IPluginModelBase> pluginModelBaseList = new ArrayList<IPluginModelBase>();
        IProduct product = this.getProduct();
        BundleDescription[] bundleDescriptionArray = bundles = TargetPlatformHelper.getState().getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase pluginModel;
            BundleDescription bundleDescription = bundleDescriptionArray[n2];
            if (!product.containsPlugin(bundleDescription.getSymbolicName()) && (pluginModel = PluginRegistry.findModel((BundleDescription)bundleDescription)) != null) {
                pluginModelBaseList.add(pluginModel);
            }
            ++n2;
        }
        return pluginModelBaseList.toArray(new IPluginModelBase[pluginModelBaseList.size()]);
    }

    private void addPlugin(String id, String version) {
        IProduct product = this.getProduct();
        IProductModelFactory factory = product.getModel().getFactory();
        IProductPlugin plugin = factory.createPlugin();
        plugin.setId(id);
        plugin.setVersion(version);
        product.addPlugins(new IProductPlugin[]{plugin});
        this.fPluginTable.setSelection((ISelection)new StructuredSelection((Object)plugin));
    }

    private IProduct getProduct() {
        return this.getModel().getProduct();
    }

    private IProductModel getModel() {
        return (IProductModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.handleModelEventWorldChanged(e);
            return;
        }
        Object[] objects = e.getChangedObjects();
        if (e.getChangeType() == 1) {
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof IProductPlugin) {
                    this.fPluginTable.add(object);
                }
                ++n2;
            }
        } else if (e.getChangeType() == 2) {
            Table table = this.fPluginTable.getTable();
            int index = table.getSelectionIndex();
            Object[] objectArray = objects;
            int n = objects.length;
            int n3 = 0;
            while (n3 < n) {
                Object object = objectArray[n3];
                if (object instanceof IProductPlugin) {
                    this.fPluginTable.remove(object);
                }
                ++n3;
            }
            int count = table.getItemCount();
            if (count != 0) {
                if (index < count) {
                    table.setSelection(index);
                } else {
                    table.setSelection(count - 1);
                }
            }
        } else if (e.getChangeType() == 3) {
            this.fPluginTable.refresh();
        }
        this.updateRemoveButtons(false, true);
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        if (this.fPluginTable.getTable().isDisposed()) {
            return;
        }
        this.fPluginTable.setInput((Object)this.getProduct());
        this.refresh();
    }

    public void refresh() {
        this.fPluginTable.refresh();
        this.updateRemoveButtons(true, true);
        super.refresh();
    }

    public void modelsChanged(PluginModelDelta delta) {
        Control control = this.fPluginTable.getControl();
        if (!control.isDisposed()) {
            control.getDisplay().asyncExec(() -> {
                if (!control.isDisposed()) {
                    this.fPluginTable.refresh();
                    this.updateRemoveButtons(true, true);
                }
            });
        }
    }

    private IPluginModelBase findModel(IAdaptable object) {
        if (object instanceof IJavaProject) {
            object = ((IJavaProject)object).getProject();
        }
        if (object instanceof IProject) {
            return PluginRegistry.findModel((IProject)((IProject)object));
        }
        if (object instanceof PersistablePluginObject) {
            return PluginRegistry.findModel((String)((PersistablePluginObject)object).getPluginID());
        }
        return null;
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
        this.updateRemoveButtons(true, false);
    }

    public boolean setFormInput(Object input) {
        if (input instanceof IProductPlugin) {
            this.fPluginTable.setSelection((ISelection)new StructuredSelection(input), true);
            return true;
        }
        return super.setFormInput(input);
    }

    @Override
    protected void doPaste(Object target, Object[] objects) {
        IProductPlugin[] plugins;
        if (objects instanceof IProductPlugin[]) {
            plugins = (IProductPlugin[])objects;
        } else {
            plugins = new IProductPlugin[objects.length];
            int i = 0;
            while (i < objects.length) {
                if (objects[i] instanceof IProductPlugin) {
                    plugins[i] = (IProductPlugin)objects[i];
                }
                ++i;
            }
        }
        this.getProduct().addPlugins(plugins);
    }

    private void updateRemoveButtons(boolean updateRemove, boolean updateRemoveAll) {
        EditableTablePart tablePart = this.getTablePart();
        Table table = tablePart.getTableViewer().getTable();
        TableItem[] tableSelection = table.getSelection();
        if (updateRemove) {
            IStructuredSelection selection = this.getViewerSelection();
            tablePart.setButtonEnabled(3, this.isEditable() && !selection.isEmpty() && selection instanceof IStructuredSelection && selection.getFirstElement() instanceof IProductPlugin);
        }
        int count = this.fPluginTable.getTable().getItemCount();
        if (updateRemoveAll) {
            tablePart.setButtonEnabled(4, this.isEditable() && count > 0);
        }
        tablePart.setButtonEnabled(2, this.isEditable() && count > 0);
        tablePart.setButtonEnabled(5, this.isEditable() && tableSelection.length == 1);
    }

    @Override
    protected boolean createCount() {
        return true;
    }

    public boolean includeOptionalDependencies() {
        return this.fIncludeOptionalButton.getSelection();
    }

    class ContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return PluginSection.this.getProduct().getPlugins();
        }
    }

    class NewFragmentAction
    extends Action {
        public NewFragmentAction() {
            super(PDEUIMessages.Product_PluginSection_newFragment, 1);
            this.setImageDescriptor(PDEPluginImages.DESC_NEWFRAGPRJ_TOOL);
        }

        public void run() {
            PluginSection.this.handleNewFragment();
        }
    }

    class NewPluginAction
    extends Action {
        public NewPluginAction() {
            super(PDEUIMessages.Product_PluginSection_newPlugin, 1);
            this.setImageDescriptor(PDEPluginImages.DESC_NEWPPRJ_TOOL);
        }

        public void run() {
            PluginSection.this.handleNewPlugin();
        }
    }
}

