/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.validation;

import com.google.inject.Singleton;
import java.util.Arrays;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.ts.types.BuiltInType;
import org.eclipse.n4js.ts.types.MemberAccessModifier;
import org.eclipse.n4js.ts.types.PrimitiveType;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TEnum;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.types.TStructField;
import org.eclipse.n4js.ts.types.TStructGetter;
import org.eclipse.n4js.ts.types.TStructSetter;
import org.eclipse.n4js.ts.types.TVariable;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeAccessModifier;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.types.TypesFactory;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.ts.types.TypingStrategy;

@Singleton
public class TypesKeywordProvider {
    public String keywordWithIndefiniteArticle(EObject elem) {
        char firstChar;
        int _indexOf;
        boolean _greaterThan;
        String keyword = this.keyword(elem);
        char _xifexpression = '\u0000';
        int _length = keyword.length();
        boolean bl = _greaterThan = _length > 0;
        if (_greaterThan) {
            _xifexpression = Character.toLowerCase(keyword.charAt(0));
        }
        boolean startsWithVowel = (_indexOf = "aeiou".indexOf(firstChar = _xifexpression)) >= 0;
        String _xifexpression_1 = null;
        _xifexpression_1 = startsWithVowel ? "an " + keyword : "a " + keyword;
        return _xifexpression_1;
    }

    public String keyword(EObject elem, TypingStrategy typingStrategy) {
        if (typingStrategy == TypingStrategy.STRUCTURAL_FIELD_INITIALIZER) {
            EClass replacementType;
            EClass _switchResult = null;
            boolean _matched = false;
            if (elem instanceof TStructGetter) {
                _matched = true;
                _switchResult = TypesPackage.eINSTANCE.getTStructSetter();
            }
            if (!_matched && elem instanceof TStructSetter) {
                _matched = true;
                _switchResult = TypesPackage.eINSTANCE.getTStructGetter();
            }
            if (!_matched && elem instanceof TGetter) {
                _matched = true;
                _switchResult = TypesPackage.eINSTANCE.getTSetter();
            }
            if (!_matched && elem instanceof TSetter) {
                _matched = true;
                _switchResult = TypesPackage.eINSTANCE.getTGetter();
            }
            if ((replacementType = _switchResult) != null) {
                return this.keyword(TypesFactory.eINSTANCE.create(replacementType));
            }
        }
        return this.keyword(elem);
    }

    protected String _keyword(EObject eobj) {
        String modelName = eobj.eClass().getName();
        int _length = modelName.length();
        int _plus = _length + 1;
        StringBuilder strb = new StringBuilder(_plus);
        int i = 0;
        while (i < modelName.length()) {
            char c = modelName.charAt(i);
            boolean _isUpperCase = Character.isUpperCase(c);
            if (_isUpperCase) {
                if (i > 0) {
                    strb.append(" ");
                }
                strb.append(Character.toLowerCase(c));
            } else {
                strb.append(c);
            }
            ++i;
        }
        return strb.toString();
    }

    protected String _keyword(TClass n4Class) {
        return "class";
    }

    protected String _keyword(TEnum tEnum) {
        return "enum";
    }

    protected String _keyword(TInterface n4Interface) {
        return "interface";
    }

    protected String _keyword(TClassifier n4Classifier) {
        return "classifier";
    }

    protected String _keyword(TMember n4Member) {
        return "member";
    }

    protected String _keyword(TStructField structField) {
        return "structural field";
    }

    protected String _keyword(TStructGetter structGetter) {
        return "structural getter";
    }

    protected String _keyword(TStructSetter structSetter) {
        return "structural setter";
    }

    protected String _keyword(TField n4Field) {
        return "field";
    }

    protected String _keyword(TMethod tMethod) {
        String _xifexpression = null;
        boolean _isConstructor = tMethod.isConstructor();
        _xifexpression = _isConstructor ? "constructor" : "method";
        return _xifexpression;
    }

    protected String _keyword(TFunction function) {
        return "function";
    }

    protected String _keyword(TGetter n4Getter) {
        return "getter";
    }

    protected String _keyword(TSetter n4Setter) {
        return "setter";
    }

    protected String _keyword(TVariable variable) {
        return "variable";
    }

    protected String _keyword(TFormalParameter parameter) {
        return "parameter";
    }

    protected String _keyword(TypeVariable variable) {
        return "type variable";
    }

    protected String _keyword(PrimitiveType primitive) {
        return "primitive";
    }

    protected String _keyword(BuiltInType primitive) {
        return "built-in type";
    }

    protected String _keyword(Type other) {
        return "type";
    }

    protected String _keyword(TypeAccessModifier accessModifier) {
        String _switchResult = null;
        if (accessModifier != null) {
            switch (accessModifier) {
                case PUBLIC_INTERNAL: {
                    _switchResult = "@Internal public";
                    break;
                }
                default: {
                    _switchResult = accessModifier.getName();
                    break;
                }
            }
        } else {
            _switchResult = accessModifier.getName();
        }
        return _switchResult;
    }

    protected String _keyword(MemberAccessModifier accessModifier) {
        String _switchResult = null;
        if (accessModifier != null) {
            switch (accessModifier) {
                case PUBLIC_INTERNAL: {
                    _switchResult = "@Internal public";
                    break;
                }
                case PROTECTED_INTERNAL: {
                    _switchResult = "@Internal protected";
                    break;
                }
                default: {
                    _switchResult = accessModifier.getName();
                    break;
                }
            }
        } else {
            _switchResult = accessModifier.getName();
        }
        return _switchResult;
    }

    public String keyword(Object n4Class) {
        if (n4Class instanceof TClass) {
            return this._keyword((TClass)n4Class);
        }
        if (n4Class instanceof TInterface) {
            return this._keyword((TInterface)n4Class);
        }
        if (n4Class instanceof TMethod) {
            return this._keyword((TMethod)n4Class);
        }
        if (n4Class instanceof TStructGetter) {
            return this._keyword((TStructGetter)n4Class);
        }
        if (n4Class instanceof TStructSetter) {
            return this._keyword((TStructSetter)n4Class);
        }
        if (n4Class instanceof PrimitiveType) {
            return this._keyword((PrimitiveType)n4Class);
        }
        if (n4Class instanceof TClassifier) {
            return this._keyword((TClassifier)n4Class);
        }
        if (n4Class instanceof TEnum) {
            return this._keyword((TEnum)n4Class);
        }
        if (n4Class instanceof TFunction) {
            return this._keyword((TFunction)n4Class);
        }
        if (n4Class instanceof TGetter) {
            return this._keyword((TGetter)n4Class);
        }
        if (n4Class instanceof TSetter) {
            return this._keyword((TSetter)n4Class);
        }
        if (n4Class instanceof TStructField) {
            return this._keyword((TStructField)n4Class);
        }
        if (n4Class instanceof BuiltInType) {
            return this._keyword((BuiltInType)n4Class);
        }
        if (n4Class instanceof TField) {
            return this._keyword((TField)n4Class);
        }
        if (n4Class instanceof TypeVariable) {
            return this._keyword((TypeVariable)n4Class);
        }
        if (n4Class instanceof TVariable) {
            return this._keyword((TVariable)n4Class);
        }
        if (n4Class instanceof Type) {
            return this._keyword((Type)n4Class);
        }
        if (n4Class instanceof TFormalParameter) {
            return this._keyword((TFormalParameter)n4Class);
        }
        if (n4Class instanceof TMember) {
            return this._keyword((TMember)n4Class);
        }
        if (n4Class instanceof MemberAccessModifier) {
            return this._keyword((MemberAccessModifier)n4Class);
        }
        if (n4Class instanceof TypeAccessModifier) {
            return this._keyword((TypeAccessModifier)n4Class);
        }
        if (n4Class instanceof EObject) {
            return this._keyword((EObject)n4Class);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(n4Class).toString());
    }
}

