/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.xtext.lib.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.Set;
import org.eclipse.xpect.text.IRegion;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.validation.Issue;

public class IssueOverlapsRangePredicate
implements Predicate<Issue> {
    private final Set<Severity> severities;
    private final IRegion region;

    public IssueOverlapsRangePredicate(IRegion region, Set<Severity> severity) {
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkNotNull(severity);
        this.region = region;
        this.severities = severity;
    }

    public boolean apply(Issue issue) {
        if (!this.severities.contains(issue.getSeverity())) {
            return false;
        }
        Integer offset = issue.getOffset();
        Integer length = issue.getLength();
        int start = this.region.getOffset();
        int end = start + this.region.getLength();
        return offset != null && length != null && offset < end && offset + length > start;
    }

    public IRegion getRegion() {
        return this.region;
    }

    public Set<Severity> getSeverity() {
        return this.severities;
    }

    public String toString() {
        return "Severities:" + this.severities + " Region:" + this.region;
    }
}

