/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.containers;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.util.Collections;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.ts.ui.navigation.URIBasedStorage;
import org.eclipse.n4js.ui.projectModel.IN4JSEclipseCore;
import org.eclipse.n4js.ui.projectModel.IN4JSEclipseProject;
import org.eclipse.n4js.utils.resources.IExternalResource;
import org.eclipse.xtext.ui.resource.IStorage2UriMapperContribution;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

@Singleton
public class N4JSExternalLibraryStorage2UriMapperContribution
implements IStorage2UriMapperContribution {
    @Inject
    private IN4JSEclipseCore eclipseCore;

    public void initializeCache() {
    }

    public boolean isRejected(IFolder folder) {
        return false;
    }

    public Iterable<Pair<IStorage, IProject>> getStorages(URI uri) {
        IN4JSEclipseProject project = (IN4JSEclipseProject)this.eclipseCore.findProject(uri).orNull();
        if (project != null && project.exists()) {
            IProject resourceProject = project.getProject();
            return Collections.singleton(Tuples.create((Object)new URIBasedStorage(uri), (Object)resourceProject));
        }
        return Collections.emptyList();
    }

    public URI getUri(IStorage storage) {
        File externalResource;
        if (storage instanceof IExternalResource && (externalResource = ((IExternalResource)storage).getExternalResource()).isFile()) {
            return new FileURI(externalResource).toURI();
        }
        return null;
    }
}

