/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.handler;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.n4js.ui.handler.GeneratedJsFileLocator;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;

public class OpenGeneratedSourceInEditorHandler
extends AbstractHandler {
    @Inject
    private GeneratedJsFileLocator fileLocator;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Optional<IFile> generatedSource;
        IEditorInput input;
        IEditorPart editorPart;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection == null) {
            return null;
        }
        if (selection.isEmpty()) {
            return null;
        }
        AtomicReference<IFile> fileRef = new AtomicReference<IFile>();
        if (selection instanceof IStructuredSelection) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element instanceof IFile) {
                fileRef.set((IFile)element);
            }
        } else if (selection instanceof ITextSelection && (editorPart = HandlerUtil.getActiveEditor((ExecutionEvent)event)) != null && (input = editorPart.getEditorInput()) instanceof IFileEditorInput) {
            fileRef.set(((IFileEditorInput)input).getFile());
        }
        if (fileRef.get() != null && (generatedSource = this.fileLocator.tryGetGeneratedSourceForN4jsFile((IFile)fileRef.get())).isPresent()) {
            this.tryOpenFileInEditor((IFile)fileRef.get(), (IFile)generatedSource.get());
        }
        return null;
    }

    private void tryOpenFileInEditor(IFile file, IFile generatedFile) {
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
        if (desc != null) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                page.openEditor((IEditorInput)new FileEditorInput(generatedFile), desc.getId());
            }
            catch (PartInitException e) {
                throw new RuntimeException("Error while trying to open generated JS file for " + file, e);
            }
        }
    }
}

